package cn.sylinx.hbatis.db.dialect.sql;

import cn.sylinx.hbatis.kit.Tuple;

public class DerbySqlBuilder extends DefaultSqlBuilder {

	@Override
	public Tuple buildPaginatorSql(String preSql, int pageNumber, int pageSize) {

		String sqlCount = "select count(1) as totalCount from (" + preSql + ") as temp";
		String sqlLimit = preSql + " OFFSET ? ROWS FETCH NEXT ? ROWS ONLY";
		int offset = pageSize * (pageNumber - 1);
		Object[] pms = new Object[] { offset, pageSize };
		return Tuple.apply(sqlCount, sqlLimit, pms);
	}

	@Override
	public String buildValidateQuery() {
		return "values 1";
	}
	
}
