package cn.sylinx.hbatis.db.cache;

public final class CacheKitManager {

	private static ICacheKit cacheKit = new NoCacheKit();

	public static ICacheKit get() {
		synchronized (CacheKitManager.class) {
			return cacheKit;
		}
	}

	public static void set(ICacheKit cacheKit) {
		synchronized (CacheKitManager.class) {
			if (cacheKit != null && cacheKit.isInited()) {
				CacheKitManager.cacheKit = cacheKit;
			}
		}
	}
	
	private static final class NoCacheKit implements ICacheKit {

		@Override
		public boolean isInited() {
			return false;
		}

		@Override
		public <T> T get(String cacheName, Object key, IDataLoader<?> dataLoader) {
			return null;
		}

	}
}
