/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.db.common;

import cn.sylinx.hbatis.db.common.Callable;
import cn.sylinx.hbatis.db.common.ITransaction;
import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.db.dialect.Dialect;
import cn.sylinx.hbatis.db.dialect.DialectFatory;
import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import cn.sylinx.hbatis.ds.JdbcBlock;
import cn.sylinx.hbatis.ds.JdbcResource;
import cn.sylinx.hbatis.ds.JdbcResourceManager;
import cn.sylinx.hbatis.ds.ResourceHelper;
import cn.sylinx.hbatis.exception.HbatisException;
import cn.sylinx.hbatis.exception.NestedTransactionException;
import cn.sylinx.hbatis.kit.DbKit;
import cn.sylinx.hbatis.kit.Ret;
import cn.sylinx.hbatis.kit.Tuple;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.model.ModelFabric;
import cn.sylinx.hbatis.plugin.transaction.TransactionIsolationWrapper;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DbPro {
    public static final int DEFAULT_BATCH_SIZE = 500;
    private final JdbcResource jdbcResource;
    private final String dataSourceName;
    private final Dialect dialect;

    DbPro(String jdbcResourceName) {
        this.jdbcResource = JdbcResourceManager.get().get(jdbcResourceName);
        if (this.jdbcResource == null) {
            throw new HbatisException("jdbc resource not found by jdbcResourceName: " + jdbcResourceName);
        }
        this.dataSourceName = this.jdbcResource.getDataSourceName();
        this.dialect = DialectFatory.get().createDialect(this.jdbcResource.getDbType());
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public <T> T call(final Callable<T> callable) {
        return (T)ResourceHelper.using(this.jdbcResource, new JdbcBlock<T>(){

            @Override
            public T applyBlock(Connection conn) throws SQLException {
                return callable.call(conn);
            }
        });
    }

    public static DbPro use(String jdbcResourceName) {
        DbPro result = new DbPro(jdbcResourceName);
        return result;
    }

    public static DbPro use() {
        return new DbPro("_hbatis_default_jdbc_resource");
    }

    public int[] batch(List<String> sql) {
        return this.batch(sql, 500);
    }

    public int[] batch(String sql, Object[][] params) {
        return this.batch(sql, params, 500);
    }

    public int[] batch(final String sql, final Object[][] params, final int batchSize) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<int[]>(){

            private int[] batchInner(Connection conn, String sql2, Object[][] params2, int batchSize2) throws SQLException {
                if (params2 == null || params2.length == 0) {
                    throw new IllegalArgumentException("The paras array length must more than 0.");
                }
                if (batchSize2 < 1) {
                    throw new IllegalArgumentException("The batchSize must more than 0.");
                }
                int counter = 0;
                int pointer = 0;
                int[] result = new int[params2.length];
                PreparedStatement pst = conn.prepareStatement(sql2);
                for (int i = 0; i < params2.length; ++i) {
                    DbPro.this.dialect.setParameters(pst, params2[i]);
                    pst.addBatch();
                    if (++counter < batchSize2) continue;
                    counter = 0;
                    int[] r = pst.executeBatch();
                    conn.commit();
                    for (int k = 0; k < r.length; ++k) {
                        result[pointer++] = r[k];
                    }
                }
                int[] r = pst.executeBatch();
                conn.commit();
                for (int k = 0; k < r.length; ++k) {
                    result[pointer++] = r[k];
                }
                DbKit.closeQuietly(pst);
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] applyBlock(Connection conn) throws SQLException {
                Boolean autoCommit = null;
                try {
                    autoCommit = conn.getAutoCommit();
                    conn.setAutoCommit(false);
                    int[] nArray = this.batchInner(conn, sql, params, batchSize);
                    return nArray;
                }
                catch (Exception e) {
                    GLog.error("batch error:", e);
                    conn.rollback();
                    int[] nArray = null;
                    return nArray;
                }
                finally {
                    if (autoCommit != null) {
                        conn.setAutoCommit(autoCommit);
                    }
                }
            }
        });
    }

    public int[] batch(final List<String> sqlList, final int batchSize) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<int[]>(){

            private int[] batchInner(Connection conn, List<String> sqlList2, int batchSize2) throws SQLException {
                if (sqlList2 == null || sqlList2.size() == 0) {
                    throw new IllegalArgumentException("The sqlList length must more than 0.");
                }
                if (batchSize2 < 1) {
                    throw new IllegalArgumentException("The batchSize must more than 0.");
                }
                int counter = 0;
                int pointer = 0;
                int size = sqlList2.size();
                int[] result = new int[size];
                Statement st = conn.createStatement();
                for (int i = 0; i < size; ++i) {
                    st.addBatch(sqlList2.get(i));
                    if (++counter < batchSize2) continue;
                    counter = 0;
                    int[] r = st.executeBatch();
                    conn.commit();
                    for (int k = 0; k < r.length; ++k) {
                        result[pointer++] = r[k];
                    }
                }
                int[] r = st.executeBatch();
                conn.commit();
                for (int k = 0; k < r.length; ++k) {
                    result[pointer++] = r[k];
                }
                DbKit.closeQuietly(st);
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] applyBlock(Connection conn) throws SQLException {
                Boolean autoCommit = null;
                try {
                    autoCommit = conn.getAutoCommit();
                    conn.setAutoCommit(false);
                    int[] nArray = this.batchInner(conn, sqlList, batchSize);
                    return nArray;
                }
                catch (Exception e) {
                    GLog.error("batch error:", e);
                    conn.rollback();
                    int[] nArray = null;
                    return nArray;
                }
                finally {
                    if (autoCommit != null) {
                        conn.setAutoCommit(autoCommit);
                    }
                }
            }
        });
    }

    public boolean transaction(final ITransaction transaction) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean applyBlock(Connection conn) throws SQLException {
                Connection transCon = DbPro.this.jdbcResource.getTransactionConnection();
                if (transCon != null) {
                    Ret result = transaction.run();
                    if (result.isSuccess()) {
                        return true;
                    }
                    throw new NestedTransactionException("Notice the outer transaction that the nested transaction return false");
                }
                Boolean autoCommit = null;
                try {
                    autoCommit = conn.getAutoCommit();
                    int transactionIsolation = transaction.transactionIsolation() == null ? TransactionIsolationWrapper.ME.getTransactionIsolation() : transaction.transactionIsolation().intValue();
                    conn.setTransactionIsolation(transactionIsolation);
                    conn.setAutoCommit(false);
                    DbPro.this.jdbcResource.setTransactionConnection(conn);
                    Ret result = transaction.run();
                    if (result.isSuccess()) {
                        conn.commit();
                    } else {
                        conn.rollback();
                    }
                    Boolean bl = result.isSuccess();
                    return bl;
                }
                catch (Throwable t) {
                    GLog.error("transaction error :", t);
                    conn.rollback();
                }
                finally {
                    conn.setAutoCommit(autoCommit);
                    DbPro.this.jdbcResource.removeTransactionConnection();
                }
                return false;
            }
        });
    }

    public Ret transactionWithReturn(final ITransaction transaction) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<Ret>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Ret applyBlock(Connection conn) throws SQLException {
                Connection transCon = DbPro.this.jdbcResource.getTransactionConnection();
                if (transCon != null) {
                    Ret result = transaction.run();
                    if (result.isSuccess()) {
                        return Ret.success();
                    }
                    throw new NestedTransactionException("Notice the outer transaction that the nested transaction return false");
                }
                Boolean autoCommit = null;
                try {
                    autoCommit = conn.getAutoCommit();
                    int transactionIsolation = transaction.transactionIsolation() == null ? TransactionIsolationWrapper.ME.getTransactionIsolation() : transaction.transactionIsolation().intValue();
                    conn.setTransactionIsolation(transactionIsolation);
                    conn.setAutoCommit(false);
                    DbPro.this.jdbcResource.setTransactionConnection(conn);
                    Ret result = transaction.run();
                    if (result.isSuccess()) {
                        conn.commit();
                    } else {
                        conn.rollback();
                    }
                    Ret ret = result;
                    return ret;
                }
                catch (Throwable t) {
                    GLog.error("transaction error :", t);
                    conn.rollback();
                    Ret ret = Ret.error(t.getMessage());
                    return ret;
                }
                finally {
                    conn.setAutoCommit(autoCommit);
                    DbPro.this.jdbcResource.removeTransactionConnection();
                }
            }
        });
    }

    public <T> int delete(T t) {
        if (t == null) {
            throw new HbatisException("\u6a21\u578b\u4e3a\u7a7a");
        }
        Tuple tuple = null;
        try {
            tuple = this.getDialect().getSqlBuilder().buildDeleteSQL(t);
        }
        catch (Exception e) {
            GLog.error("ModelBuilder.buildDeleteSQL(t, mapper) error: ", e);
        }
        if (tuple == null) {
            return 0;
        }
        String updateSql = (String)tuple.get(0);
        Object[] params = (Object[])tuple.get(1);
        return this.update(updateSql, params);
    }

    public <T> Serializable save(T t) {
        if (t == null) {
            throw new HbatisException("\u6a21\u578b\u4e3a\u7a7a");
        }
        Tuple tuple = null;
        try {
            tuple = this.getDialect().getSqlBuilder().buildInsertSQL(t);
        }
        catch (Exception e) {
            GLog.error("ModelBuilder.buildInsertSQL(t, mapper) error: ", e);
        }
        if (tuple == null) {
            return null;
        }
        String updateSql = (String)tuple.get(0);
        Object[] params = (Object[])tuple.get(1);
        return this.save(updateSql, params);
    }

    public <T> int update(T t) {
        if (t == null) {
            throw new HbatisException("\u66f4\u65b0\u5bf9\u8c61\u4e3a\u7a7a");
        }
        Tuple tuple = null;
        try {
            tuple = this.getDialect().getSqlBuilder().buildUpdateSQL(t);
        }
        catch (Exception e) {
            GLog.error("ModelBuilder.buildUpdateSQL(t, mapper) error: ", e);
            throw new RuntimeException(e);
        }
        if (tuple == null) {
            return 0;
        }
        String updateSql = (String)tuple.get(0);
        Object[] params = (Object[])tuple.get(1);
        return this.update(updateSql, params);
    }

    public boolean execute(final String exeSql, final Object ... params) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<Boolean>(){

            @Override
            public Boolean applyBlock(Connection conn) throws SQLException {
                PreparedStatement pst = conn.prepareStatement(exeSql);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                boolean bl = pst.execute();
                DbKit.closeQuietly(pst);
                return bl;
            }
        });
    }

    public boolean executeLargeUpdate(final List<String> exeSqlList) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<Boolean>(){

            @Override
            public Boolean applyBlock(Connection conn) {
                try {
                    Statement st = conn.createStatement();
                    for (String sql : exeSqlList) {
                        st.addBatch(sql);
                    }
                    int[] rst = st.executeBatch();
                    GLog.info("executeLargeUpdate rst:{}", new Object[]{rst});
                    DbKit.closeQuietly(st);
                }
                catch (Exception e) {
                    GLog.error("executeLargeUpdate error ", e);
                    return false;
                }
                return true;
            }
        });
    }

    public int update(String updateSql, Object ... params) {
        return this.call(conn -> {
            int result;
            PreparedStatement pst = conn.prepareStatement(updateSql);
            if (params != null) {
                this.dialect.setParameters(pst, params);
            }
            if ((result = pst.executeUpdate()) < 1) {
                GLog.info("0 rows updated, sql:{}, params:{}", updateSql, params);
            }
            DbKit.closeQuietly(pst);
            return result;
        });
    }

    public Serializable save(String insertSql, Object ... params) {
        return this.updateWithReturnPk(insertSql, params);
    }

    public Serializable updateWithReturnPk(final String updateSql, final Object ... params) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<Serializable>(){

            @Override
            public Serializable applyBlock(Connection conn) throws SQLException {
                ResultSet rs;
                int result;
                PreparedStatement pst = conn.prepareStatement(updateSql, 1);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                if ((result = pst.executeUpdate()) < 1) {
                    GLog.error("update error, sql:" + updateSql, new Object[0]);
                }
                Object pk = (rs = pst.getGeneratedKeys()).next() ? rs.getObject(1) : null;
                DbKit.closeQuietly(rs, pst);
                return (Serializable)pk;
            }
        });
    }

    public Map<String, Object> queryFirstMap(final String sql, final Object ... params) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<Map<String, Object>>(){

            @Override
            public Map<String, Object> applyBlock(Connection conn) throws SQLException {
                PreparedStatement pst = conn.prepareStatement(sql);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                ResultSet rs = pst.executeQuery();
                ResultSetMetaData rsmetas = rs.getMetaData();
                int columnCount = rsmetas.getColumnCount();
                HashMap<String, Object> result = new HashMap<String, Object>();
                if (rs.next()) {
                    int len = columnCount + 1;
                    for (int i = 1; i < len; ++i) {
                        result.put(rsmetas.getColumnLabel(i).toUpperCase(), rs.getObject(i));
                    }
                }
                DbKit.closeQuietly(rs, pst);
                return result;
            }
        });
    }

    public Object[] queryFirst(final String sql, final Object ... params) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<Object[]>(){

            @Override
            public Object[] applyBlock(Connection conn) throws SQLException {
                PreparedStatement pst = conn.prepareStatement(sql);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                ResultSet rs = pst.executeQuery();
                ResultSetMetaData rsmetas = rs.getMetaData();
                int columnCount = rsmetas.getColumnCount();
                Object[] result = null;
                if (rs.next()) {
                    result = new Object[columnCount];
                    int len = columnCount + 1;
                    for (int i = 1; i < len; ++i) {
                        result[i - 1] = rs.getObject(i);
                    }
                }
                DbKit.closeQuietly(rs, pst);
                return result;
            }
        });
    }

    public Record queryFirstRecord(final String sql, final Object ... params) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<Record>(){

            @Override
            public Record applyBlock(Connection conn) throws SQLException {
                PreparedStatement pst = conn.prepareStatement(sql);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                ResultSet rs = pst.executeQuery();
                ResultSetMetaData rsmetas = rs.getMetaData();
                int columnCount = rsmetas.getColumnCount();
                Record tmp = null;
                if (rs.next()) {
                    tmp = new Record();
                    int len = columnCount + 1;
                    for (int i = 1; i < len; ++i) {
                        tmp.put(rsmetas.getColumnLabel(i), i, rs.getObject(i));
                    }
                }
                DbKit.closeQuietly(rs, pst);
                return tmp;
            }
        });
    }

    public List<Record> queryRecords(final String sql, final Object ... params) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<List<Record>>(){

            @Override
            public List<Record> applyBlock(Connection conn) throws SQLException {
                ArrayList<Record> result = new ArrayList<Record>();
                PreparedStatement pst = conn.prepareStatement(sql);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                ResultSet rs = pst.executeQuery();
                ResultSetMetaData rsmetas = rs.getMetaData();
                int columnCount = rsmetas.getColumnCount();
                Record tmp = null;
                while (rs.next()) {
                    tmp = new Record();
                    int len = columnCount + 1;
                    for (int i = 1; i < len; ++i) {
                        tmp.put(rsmetas.getColumnLabel(i), i, rs.getObject(i));
                    }
                    result.add(tmp);
                }
                DbKit.closeQuietly(rs, pst);
                return result;
            }
        });
    }

    public List<Map<String, Object>> queryMap(final String sql, final Object ... params) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<List<Map<String, Object>>>(){

            @Override
            public List<Map<String, Object>> applyBlock(Connection conn) throws SQLException {
                ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
                PreparedStatement pst = conn.prepareStatement(sql);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                ResultSet rs = pst.executeQuery();
                ResultSetMetaData rsmetas = rs.getMetaData();
                int columnCount = rsmetas.getColumnCount();
                HashMap<String, Object> tmp = null;
                while (rs.next()) {
                    tmp = new HashMap<String, Object>();
                    int len = columnCount + 1;
                    for (int i = 1; i < len; ++i) {
                        tmp.put(rsmetas.getColumnLabel(i).toUpperCase(), rs.getObject(i));
                    }
                    result.add(tmp);
                }
                DbKit.closeQuietly(rs, pst);
                return result;
            }
        });
    }

    public List<Object[]> query(final String sql, final Object ... params) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<List<Object[]>>(){

            @Override
            public List<Object[]> applyBlock(Connection conn) throws SQLException {
                ArrayList<Object[]> result = new ArrayList<Object[]>();
                PreparedStatement pst = conn.prepareStatement(sql);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                ResultSet rs = pst.executeQuery();
                ResultSetMetaData rsmetas = rs.getMetaData();
                int columnCount = rsmetas.getColumnCount();
                while (rs.next()) {
                    Object[] row = new Object[columnCount];
                    int len = columnCount + 1;
                    for (int i = 1; i < len; ++i) {
                        row[i - 1] = rs.getObject(i);
                    }
                    result.add(row);
                }
                DbKit.closeQuietly(rs, pst);
                return result;
            }
        });
    }

    public <T> T queryFirst(String sql, QueryMapper<T> mapper, Object ... params) {
        if (mapper == null) {
            return (T)this.queryFirst(sql, params);
        }
        return (T)this.call(conn -> {
            PreparedStatement pst = conn.prepareStatement(sql);
            if (params != null) {
                this.dialect.setParameters(pst, params);
            }
            ResultSet rs = pst.executeQuery();
            Object result = null;
            try {
                result = this.buildFirstQueryModel(rs, mapper);
            }
            catch (InstantiationException e) {
                GLog.error("buildFirstQueryModel InstantiationException occur:", e);
            }
            catch (IllegalAccessException e) {
                GLog.error("buildFirstQueryModel IllegalAccessException occur:", e);
            }
            DbKit.closeQuietly(rs, pst);
            return result;
        });
    }

    public <T> T buildFirstQueryModel(ResultSet rs, QueryMapper<T> mapper) throws SQLException, InstantiationException, IllegalAccessException {
        if (mapper == null) {
            return null;
        }
        T result = null;
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        ModelBuilder.buildColumnNamesAndTypes(rsmd, labelNames, types);
        Map<String, String> maps = mapper.getJdbcToJavaMapper();
        Class<T> clz = mapper.getValueObjectClass();
        if (clz == null) {
            return null;
        }
        ModelFabric mf = ModelBuilder.getModelFabric(clz.getName());
        boolean ismapsEmpty = maps == null || maps.isEmpty();
        boolean ismappingEmpty = mf.isMappingEmpty();
        if (ismapsEmpty && ismappingEmpty) {
            if (rs.next()) {
                result = this.getDialect().getResult(rs, 1, clz);
            }
        } else {
            if (ismapsEmpty) {
                maps = mf.getJdbcMapping();
            }
            Map<String, Field> fieldMap = mf.getFieldMap();
            if (rs.next()) {
                T instance = clz.newInstance();
                for (int i = 1; i <= columnCount; ++i) {
                    Field f = fieldMap.get(maps.get(labelNames[i]));
                    if (f == null) continue;
                    Class<?> tp = f.getType();
                    Object tmp1 = this.getDialect().getResult(rs, i, tp);
                    if (tmp1 == null) continue;
                    f.setAccessible(true);
                    f.set(instance, tmp1);
                }
                result = instance;
            }
        }
        return result;
    }

    public <T> List<T> queryObject(String sql, Class<T> clazz, Object ... params) {
        return this.call(conn -> {
            PreparedStatement pst = conn.prepareStatement(sql);
            if (params != null) {
                this.dialect.setParameters(pst, params);
            }
            ResultSet rs = pst.executeQuery();
            try {
                List list = this.buildQueryObject(rs, clazz);
                return list;
            }
            finally {
                DbKit.closeQuietly(rs, pst);
            }
        });
    }

    public <T> T queryFirstObject(String sql, Class<T> clazz, Object ... params) {
        return (T)this.call(conn -> {
            PreparedStatement pst = conn.prepareStatement(sql);
            if (params != null) {
                this.dialect.setParameters(pst, params);
            }
            ResultSet rs = pst.executeQuery();
            try {
                Object t = this.buildFirstQueryObject(rs, clazz);
                return t;
            }
            finally {
                DbKit.closeQuietly(rs, pst);
            }
        });
    }

    public <T> List<T> buildQueryObject(ResultSet rs, Class<T> clazz) throws SQLException {
        ArrayList<T> result = new ArrayList<T>();
        while (rs.next()) {
            result.add(this.getDialect().getResult(rs, 1, clazz));
        }
        return result;
    }

    public <T> T buildFirstQueryObject(ResultSet rs, Class<T> clazz) throws SQLException {
        if (rs.next()) {
            return this.getDialect().getResult(rs, 1, clazz);
        }
        return null;
    }

    public <T> List<T> query(String sql, QueryMapper<T> mapper, Object ... params) {
        if (mapper == null) {
            return this.query(sql, params);
        }
        return this.call(conn -> {
            PreparedStatement pst = conn.prepareStatement(sql);
            if (params != null) {
                this.dialect.setParameters(pst, params);
            }
            ResultSet rs = pst.executeQuery();
            List result = null;
            try {
                result = this.buildQueryModel(rs, mapper);
            }
            catch (InstantiationException e) {
                GLog.error("buildQueryModel InstantiationException occur ", e);
            }
            catch (IllegalAccessException e) {
                GLog.error("buildQueryModel IllegalAccessException occur ", e);
            }
            DbKit.closeQuietly(rs, pst);
            return result;
        });
    }

    public <T> List<T> buildQueryModel(ResultSet rs, QueryMapper<T> mapper) throws SQLException, InstantiationException, IllegalAccessException {
        ArrayList<T> result = new ArrayList<T>();
        if (mapper == null) {
            return result;
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        ModelBuilder.buildColumnNamesAndTypes(rsmd, labelNames, types);
        Map<String, String> maps = mapper.getJdbcToJavaMapper();
        Class<T> clz = mapper.getValueObjectClass();
        if (clz == null) {
            return null;
        }
        ModelFabric mf = ModelBuilder.getModelFabric(clz.getName());
        Map<String, Field> fieldMap = mf.getFieldMap();
        boolean ismapsEmpty = maps == null || maps.isEmpty();
        boolean ismappingEmpty = mf.isMappingEmpty();
        if (ismapsEmpty && ismappingEmpty) {
            while (rs.next()) {
                T tmp1 = this.getDialect().getResult(rs, 1, clz);
                result.add(tmp1);
            }
        } else {
            if (ismapsEmpty) {
                maps = mf.getJdbcMapping();
            }
            while (rs.next()) {
                T instance = clz.newInstance();
                for (int i = 1; i <= columnCount; ++i) {
                    Field f = fieldMap.get(maps.get(labelNames[i]));
                    if (f == null) continue;
                    Class<?> tp = f.getType();
                    Object tmp1 = this.getDialect().getResult(rs, i, tp);
                    if (tmp1 == null) continue;
                    f.setAccessible(true);
                    f.set(instance, tmp1);
                }
                result.add(instance);
            }
        }
        return result;
    }

    public boolean existTable(String schema, String table) {
        return this.call(conn -> {
            boolean result = false;
            DatabaseMetaData dm = conn.getMetaData();
            ResultSet rs = dm.getTables(null, schema, table, new String[]{"TABLE"});
            result = rs.next();
            DbKit.closeQuietly(rs);
            return result;
        });
    }

    public boolean existTableColumn(String schema, String table, String column) {
        return this.call(conn -> {
            boolean result = false;
            DatabaseMetaData dm = conn.getMetaData();
            ResultSet rs = dm.getColumns(null, schema, table, column);
            result = rs.next();
            DbKit.closeQuietly(rs);
            return result;
        });
    }
}

