/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.xmapper;

import cn.sylinx.hbatis.db.cache.CacheQuery;
import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import cn.sylinx.hbatis.ext.parse.SqlParser;
import cn.sylinx.hbatis.ext.res.StatementHandler;
import cn.sylinx.hbatis.ext.xmapper.XmapperCacheQuery;
import cn.sylinx.hbatis.ext.xmapper.xml.QueryMapping;
import cn.sylinx.hbatis.ext.xmapper.xml.Sql;
import cn.sylinx.hbatis.ext.xmapper.xml.SqlForUse;
import cn.sylinx.hbatis.ext.xmapper.xml.XmlSqlMapper;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.kit.Tuple;
import java.util.List;
import java.util.Map;

public class DefaultXmapperCacheQuery
implements XmapperCacheQuery {
    private CacheQuery cacheQuery;

    public DefaultXmapperCacheQuery(CacheQuery cacheQuery) {
        this.cacheQuery = cacheQuery;
    }

    @Override
    public <T> List<T> query(String sqlId, Map<String, Object> params) {
        String[] ids = sqlId.split("\\.");
        String namespaceId = ids[0];
        String id = ids[1];
        return this.query(namespaceId, id, params);
    }

    @Override
    public Map<String, Object> queryFirstForMap(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.QUERY.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not query for use");
        }
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.cacheQuery.queryFirstMap(st, pms);
    }

    @Override
    public Map<String, Object> queryFirstForMap(String sqlId, Map<String, Object> params) {
        String[] ids = sqlId.split("\\.");
        String namespaceId = ids[0];
        String id = ids[1];
        return this.queryFirstForMap(namespaceId, id, params);
    }

    @Override
    public List<Map<String, Object>> queryForMapList(String sqlId, Map<String, Object> params) {
        String[] ids = sqlId.split("\\.");
        String namespaceId = ids[0];
        String id = ids[1];
        return this.queryForMapList(namespaceId, id, params);
    }

    @Override
    public List<Record> queryForRecords(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.QUERY.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not query for use");
        }
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.cacheQuery.queryRecords(st, pms);
    }

    @Override
    public List<Record> queryForRecords(String sqlId, Map<String, Object> params) {
        String[] ids = sqlId.split("\\.");
        String namespaceId = ids[0];
        String id = ids[1];
        return this.queryForRecords(namespaceId, id, params);
    }

    @Override
    public Record queryFirstRecord(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.QUERY.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not query for use");
        }
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.cacheQuery.queryFirstRecord(st, pms);
    }

    @Override
    public Record queryFirstRecord(String sqlId, Map<String, Object> params) {
        String[] ids = sqlId.split("\\.");
        String namespaceId = ids[0];
        String id = ids[1];
        return this.queryFirstRecord(namespaceId, id, params);
    }

    @Override
    public List<Object[]> queryObjectArrayList(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.QUERY.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not query for use");
        }
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.cacheQuery.query(st, pms);
    }

    @Override
    public List<Object[]> queryObjectArrayList(String sqlId, Map<String, Object> params) {
        String[] ids = sqlId.split("\\.");
        String namespaceId = ids[0];
        String id = ids[1];
        return this.queryObjectArrayList(namespaceId, id, params);
    }

    private Tuple getQueryStatement(String statement, Map<String, Object> params) {
        Object obj;
        StatementHandler sqlHandler = null;
        if (params != null && (obj = params.get(StatementHandler.class.getName())) != null && obj instanceof StatementHandler) {
            sqlHandler = (StatementHandler)obj;
        }
        return SqlParser.parseSql(statement, params, sqlHandler);
    }

    @Override
    public Object[] queryFirstObjectArray(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.QUERY.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not query for use");
        }
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.cacheQuery.queryFirst(st, pms);
    }

    @Override
    public Object[] queryFirstObjectArray(String sqlId, Map<String, Object> params) {
        String[] ids = sqlId.split("\\.");
        String namespaceId = ids[0];
        String id = ids[1];
        return this.queryFirstObjectArray(namespaceId, id, params);
    }

    @Override
    public List<Map<String, Object>> queryForMapList(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.QUERY.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not query for use");
        }
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.cacheQuery.queryMap(st, pms);
    }

    @Override
    public <T> List<T> query(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.QUERY.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not query for use");
        }
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        final QueryMapping qm = sql.getQueryMapping();
        QueryMapper qmapper = null;
        if (qm != null) {
            qmapper = new QueryMapper<T>(){

                @Override
                public Map<String, String> getJdbcToJavaMapper() {
                    return qm.getMap();
                }

                @Override
                public Class<T> getValueObjectClass() {
                    try {
                        String clzStr = qm.getReturnClass();
                        if (StrKit.isNotBlank(clzStr)) {
                            return Class.forName(clzStr);
                        }
                        return null;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            };
        }
        return this.cacheQuery.query(st, qmapper, pms);
    }

    @Override
    public <T> T queryFirst(String sqlId, Map<String, Object> params) {
        List<T> list = this.query(sqlId, params);
        return list != null && !list.isEmpty() ? (T)list.get(0) : null;
    }

    @Override
    public <T> T queryFirst(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.QUERY.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not query for use");
        }
        final QueryMapping qm = sql.getQueryMapping();
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        QueryMapper qmapper = null;
        if (qm != null) {
            qmapper = new QueryMapper<T>(){

                @Override
                public Map<String, String> getJdbcToJavaMapper() {
                    return qm.getMap();
                }

                @Override
                public Class<T> getValueObjectClass() {
                    try {
                        String clzStr = qm.getReturnClass();
                        if (StrKit.isNotBlank(clzStr)) {
                            return Class.forName(clzStr);
                        }
                        return null;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            };
        }
        return this.cacheQuery.queryFirst(st, qmapper, pms);
    }
}

