/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.starter.pool;

import cn.sylinx.hbatis.db.dialect.DbType;
import cn.sylinx.hbatis.ds.DataSourceWrapper;
import cn.sylinx.hbatis.exception.HbatisException;
import cn.sylinx.hbatis.ext.starter.pool.DefaultDataSourceSelector;
import cn.sylinx.hbatis.ext.starter.pool.PoolType;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.log.GLog;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;

public class DataSourceWrapperFactory {
    public static DataSourceWrapper buildDataSource(Map<String, Object> dsMap, Map<String, Object> extConfig) {
        String dbType = Optional.ofNullable(dsMap.get("dbtype")).orElse(DbType.MYSQL.getValue()).toString();
        String pooltype = Optional.ofNullable(dsMap.get("pooltype")).orElse("").toString();
        DataSource dataSource = new DefaultDataSourceSelector(dsMap, extConfig).select(DataSourceWrapperFactory.selectPoolType(pooltype));
        if (dataSource == null) {
            throw new HbatisException("\u7f3a\u5c11\u6570\u636e\u5e93\u8fde\u63a5\u6c60\uff0c\u8bf7\u914d\u7f6eDruid\u6216TomcatJdbc\u6216BoneCP\u6216C3P0\u6216dbcp\u6216Hikari");
        }
        GLog.debug("dataSource:{} inited, config:{}", dataSource.getClass().getName(), dataSource);
        return DataSourceWrapper.create(dataSource, DbType.getDbType(dbType));
    }

    private static PoolType selectPoolType(String pooltype) {
        PoolType manuSelectPoolType = null;
        if (StrKit.isNotBlank(pooltype)) {
            manuSelectPoolType = PoolType.getPoolType(pooltype);
        }
        if (manuSelectPoolType != null && DataSourceWrapperFactory.isClassExist(manuSelectPoolType.getClassName())) {
            return manuSelectPoolType;
        }
        if (DataSourceWrapperFactory.isDruidExist()) {
            return PoolType.Druid;
        }
        if (DataSourceWrapperFactory.isTomcatJdbcPoolExist()) {
            return PoolType.TomcatJdbc;
        }
        if (DataSourceWrapperFactory.isBoneCPExist()) {
            return PoolType.BoneCP;
        }
        if (DataSourceWrapperFactory.isC3P0Exist()) {
            return PoolType.C3P0;
        }
        if (DataSourceWrapperFactory.isDbcp2Exist()) {
            return PoolType.Dbcp2;
        }
        if (DataSourceWrapperFactory.isDbcpExist()) {
            return PoolType.Dbcp;
        }
        if (DataSourceWrapperFactory.isHikariExist()) {
            return PoolType.Hikari;
        }
        return null;
    }

    private static boolean isDruidExist() {
        return DataSourceWrapperFactory.isClassExist(PoolType.Druid.getClassName());
    }

    private static boolean isTomcatJdbcPoolExist() {
        return DataSourceWrapperFactory.isClassExist(PoolType.TomcatJdbc.getClassName());
    }

    private static boolean isDbcp2Exist() {
        return DataSourceWrapperFactory.isClassExist(PoolType.Dbcp2.getClassName());
    }

    private static boolean isDbcpExist() {
        return DataSourceWrapperFactory.isClassExist(PoolType.Dbcp.getClassName());
    }

    private static boolean isC3P0Exist() {
        return DataSourceWrapperFactory.isClassExist(PoolType.C3P0.getClassName());
    }

    private static boolean isBoneCPExist() {
        return DataSourceWrapperFactory.isClassExist(PoolType.BoneCP.getClassName());
    }

    private static boolean isHikariExist() {
        return DataSourceWrapperFactory.isClassExist(PoolType.Hikari.getClassName());
    }

    private static boolean isClassExist(String className) {
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            GLog.error("class:{} not foud ", className);
            return false;
        }
        return true;
    }
}

