/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.parse;

import cn.sylinx.hbatis.exception.HbatisException;
import cn.sylinx.hbatis.ext.parse.GenericTokenParser;
import cn.sylinx.hbatis.ext.parse.SqlTokenHandler;
import cn.sylinx.hbatis.ext.res.ClasspathSqlResource;
import cn.sylinx.hbatis.ext.res.ClasspathSqlResourceManager;
import cn.sylinx.hbatis.ext.res.StatementHandler;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.kit.Tuple;
import cn.sylinx.hbatis.log.GLog;
import java.util.Map;

public abstract class SqlParser {
    public static Tuple parseSql(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        String statement = ClasspathSqlResourceManager.getStatement(sqlResource.getSqlpath());
        if (StrKit.isBlank(statement)) {
            throw new HbatisException("SQL\u8bed\u53e5\u4e3a\u7a7a, \u8d44\u6e90:" + sqlResource.getSqlpath());
        }
        return SqlParser.parseSql(statement, params, sqlResource.getStatementHandler());
    }

    public static Tuple parseSql(String statement, Map<String, Object> params, StatementHandler sqlHandler) {
        SqlTokenHandler handler = new SqlTokenHandler(params);
        GenericTokenParser gt = new GenericTokenParser(handler);
        Tuple tp = gt.parse(statement);
        if (sqlHandler != null) {
            String statementReplace = sqlHandler.handle(tp.getObject(0, String.class));
            GLog.debug("changed sql: " + statementReplace, new Object[0]);
            return Tuple.apply(statementReplace, tp.get(1));
        }
        return tp;
    }
}

