/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.common.repository;

import cn.sylinx.hbatis.db.common.Callable;
import cn.sylinx.hbatis.db.common.ITransaction;
import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.db.dialect.Dialect;
import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import cn.sylinx.hbatis.exception.HbatisException;
import cn.sylinx.hbatis.ext.common.repository.CommonRepository;
import cn.sylinx.hbatis.ext.common.spi.HbatisServiceManager;
import cn.sylinx.hbatis.ext.model.BaseModel;
import cn.sylinx.hbatis.kit.Ret;
import cn.sylinx.hbatis.log.GLog;
import java.math.BigInteger;
import java.util.List;

public class CommonRepositoryImpl
implements CommonRepository {
    private String datasourceName;

    public CommonRepositoryImpl() {
    }

    public CommonRepositoryImpl(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    @Override
    public String getDatabase() {
        if (this.datasourceName == null) {
            this.initDatabaseInner();
        }
        return this.datasourceName;
    }

    @Override
    public Dialect getDialect() {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).getDialect();
    }

    private synchronized void initDatabaseInner() {
        if (this.datasourceName == null) {
            this.datasourceName = HbatisServiceManager.getHbatisService().getDatasourceName();
        }
    }

    @Override
    public <T> T call(Callable<T> callable) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).call(callable);
    }

    @Override
    public boolean existTable(String schema, String table) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).existTable(schema, table);
    }

    @Override
    public boolean existTableColumn(String schema, String table, String column) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).existTableColumn(schema, table, column);
    }

    @Override
    public List<Record> queryRecordsWithCache(String sql, Object ... params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).withCache().queryRecords(sql, params);
    }

    @Override
    public List<Record> queryRecordsWithCache(String sql) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).withCache().queryRecords(sql, new Object[0]);
    }

    @Override
    public Record queryRecordWithCache(String sql, Object ... params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).withCache().queryFirstRecord(sql, params);
    }

    @Override
    public Record queryRecordWithCache(String sql) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).withCache().queryFirstRecord(sql, new Object[0]);
    }

    @Override
    public boolean transaction(ITransaction transactions) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).transaction(transactions);
    }

    @Override
    public Ret transactionWithReturn(ITransaction transactions) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).transactionWithReturn(transactions);
    }

    @Override
    public <T> List<T> queryObject(String sql, Class<T> clazz, Object ... params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).queryObject(sql, clazz, params);
    }

    @Override
    public <T> T queryFirstObject(String sql, Class<T> clazz, Object ... params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).queryFirstObject(sql, clazz, params);
    }

    @Override
    public int update(String nativeSql, Object ... params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).update(nativeSql, params);
    }

    @Override
    public List<Record> queryRecords(String sql, Object ... params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).queryRecords(sql, params);
    }

    @Override
    public List<Record> queryRecords(String sql) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).queryRecords(sql, new Object[0]);
    }

    @Override
    public Record queryRecord(String sql, Object ... params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).queryFirstRecord(sql, params);
    }

    @Override
    public Record queryRecord(String sql) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).queryFirstRecord(sql, new Object[0]);
    }

    @Override
    public <T> List<T> queryListWithCache(Class<T> clz) {
        String table = ModelBuilder.getModelTable(clz);
        if (table == null) {
            throw new HbatisException("\u5bf9\u8c61\u6ca1\u6709Table\u6ce8\u89e3");
        }
        String sql = "select * from " + table;
        QueryMapper<T> mapper = ModelBuilder.buildQueryMapper(clz);
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).withCache().query(sql, mapper, new Object[0]);
    }

    @Override
    public <T> List<T> queryListWithCache(String nativeSql, Class<T> clz, Object ... params) {
        QueryMapper<T> mapper = ModelBuilder.buildQueryMapper(clz);
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).withCache().query(nativeSql, mapper, params);
    }

    @Override
    public <T> List<T> queryList(Class<T> clz) {
        String table = ModelBuilder.getModelTable(clz);
        if (table == null) {
            throw new HbatisException("\u5bf9\u8c61\u6ca1\u6709Table\u6ce8\u89e3");
        }
        String sql = "select * from " + table;
        QueryMapper<T> mapper = ModelBuilder.buildQueryMapper(clz);
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).query(sql, mapper, new Object[0]);
    }

    @Override
    public <T> List<T> queryList(String nativeSql, Class<T> clz, Object ... params) {
        QueryMapper<T> mapper = ModelBuilder.buildQueryMapper(clz);
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).query(nativeSql, mapper, params);
    }

    @Override
    public <T extends BaseModel> int update(T t) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).update(t);
    }

    @Override
    public <T extends BaseModel> int delete(T t) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).delete(t);
    }

    @Override
    public <T extends BaseModel> int delete(BigInteger id, Class<T> clz) {
        String table = ModelBuilder.getModelTable(clz);
        if (table == null) {
            throw new HbatisException("\u5bf9\u8c61\u6ca1\u6709Table\u6ce8\u89e3");
        }
        String sql = "delete from " + table + " where id = ?";
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).update(sql, id);
    }

    @Override
    public <T extends BaseModel> T save(T t) {
        if (t == null) {
            throw new HbatisException("object t is null");
        }
        Object pk = HbatisServiceManager.getHbatisService().use(this.getDatabase()).save(t);
        if (pk != null && t.getId() == null && pk instanceof Number) {
            t.setId((BigInteger)new BigInteger(pk.toString()));
        }
        return t;
    }

    @Override
    public Object insert(String insertSql, Object ... params) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).save(insertSql, params);
    }

    @Override
    public <T extends BaseModel> boolean saveNoPk(T t) {
        if (t == null) {
            throw new HbatisException("object t is null");
        }
        try {
            Object pk = HbatisServiceManager.getHbatisService().use(this.getDatabase()).save(t);
            GLog.info("save with pk:{}", pk);
        }
        catch (Exception e) {
            GLog.error("save error", e);
            return false;
        }
        return true;
    }

    @Override
    public <T> boolean saveObjectNoPk(T t) {
        if (t == null) {
            throw new HbatisException("object t is null");
        }
        try {
            Object pk = HbatisServiceManager.getHbatisService().use(this.getDatabase()).save(t);
            GLog.info("save with pk:{}", pk);
        }
        catch (Exception e) {
            GLog.error("save error", e);
            return false;
        }
        return true;
    }

    @Override
    public <T> Object saveObject(T t) {
        if (t == null) {
            throw new HbatisException("object t is null");
        }
        Object pk = HbatisServiceManager.getHbatisService().use(this.getDatabase()).save(t);
        return pk;
    }

    @Override
    public boolean executeLargeUpdate(List<String> exeSqlList) {
        return HbatisServiceManager.getHbatisService().use(this.getDatabase()).executeLargeUpdate(exeSqlList);
    }

    @Override
    public int[] batch(List<String> sql) {
        return HbatisServiceManager.getHbatisService().batch(sql);
    }

    @Override
    public int[] batch(String sql, Object[][] params) {
        return HbatisServiceManager.getHbatisService().batch(sql, params);
    }

    @Override
    public int[] batch(String sql, Object[][] params, int batchSize) {
        return HbatisServiceManager.getHbatisService().batch(sql, params, batchSize);
    }

    @Override
    public int[] batch(List<String> sqlList, int batchSize) {
        return HbatisServiceManager.getHbatisService().batch(sqlList, batchSize);
    }
}

