/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.starter.pool;

import cn.sylinx.hbatis.ext.starter.pool.BoneCPDataSourceCreator;
import cn.sylinx.hbatis.ext.starter.pool.C3p0DataSourceCreator;
import cn.sylinx.hbatis.ext.starter.pool.DataSourceSelector;
import cn.sylinx.hbatis.ext.starter.pool.Dbcp2DataSourceCreator;
import cn.sylinx.hbatis.ext.starter.pool.DbcpDataSourceCreator;
import cn.sylinx.hbatis.ext.starter.pool.DruidDataSourceCreator;
import cn.sylinx.hbatis.ext.starter.pool.PoolType;
import cn.sylinx.hbatis.ext.starter.pool.TomcatJdbcDataSourceCreator;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class DefaultDataSourceSelector
implements DataSourceSelector {
    private Map<String, Object> dsMap = new HashMap<String, Object>();
    private Map<String, Object> extConfig;

    public DefaultDataSourceSelector(Map<String, Object> dsMap, Map<String, Object> extConfig) {
        this.dsMap.putAll(dsMap);
        this.extConfig = extConfig;
        this.combined();
    }

    private void combined() {
        this.dsMap.put("config", this.extConfig);
    }

    @Override
    public DataSource select(PoolType pt) {
        if (pt == null) {
            return null;
        }
        switch (pt) {
            case Druid: {
                return new DruidDataSourceCreator().create(this.dsMap);
            }
            case TomcatJdbc: {
                return new TomcatJdbcDataSourceCreator().create(this.dsMap);
            }
            case BoneCP: {
                return new BoneCPDataSourceCreator().create(this.dsMap);
            }
            case C3P0: {
                return new C3p0DataSourceCreator().create(this.dsMap);
            }
            case Dbcp2: {
                return new Dbcp2DataSourceCreator().create(this.dsMap);
            }
            case Dbcp: {
                return new DbcpDataSourceCreator().create(this.dsMap);
            }
        }
        return null;
    }
}

