/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.starter.springboot;

import cn.sylinx.hbatis.ds.DataSourceWrapper;
import cn.sylinx.hbatis.ext.mirage.plugin.SqlResourcePreloadPlugin;
import cn.sylinx.hbatis.ext.starter.pool.DataSourceWrapperFactory;
import cn.sylinx.hbatis.ext.starter.springboot.RelaxedPropertyResolver;
import cn.sylinx.hbatis.ext.xmapper.plugin.XmapperPlugin;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.IPlugin;
import cn.sylinx.hbatis.plugin.PluginStarter;
import cn.sylinx.hbatis.plugin.datasource.DataSourcePlugin;
import cn.sylinx.hbatis.plugin.ehcache.EhcachePlugin;
import cn.sylinx.hbatis.plugin.model.ModelPreloadPlugin;
import cn.sylinx.hbatis.plugin.proxy.ProxyPlugin;
import cn.sylinx.hbatis.plugin.transaction.TransactionIsolationPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

class HbatisInitializationBean {
    private DataSourceWrapper defaultDataSource;
    private Map<String, DataSourceWrapper> multiDataSources = new HashMap<String, DataSourceWrapper>();
    private List<IPlugin> pluginList = new ArrayList<IPlugin>();

    HbatisInitializationBean() {
    }

    private DataSourceWrapper buildDataSource(Map<String, Object> dsMap, Map<String, Object> extConfig) {
        return DataSourceWrapperFactory.buildDataSource(dsMap, extConfig);
    }

    public PluginStarter init(Environment env) {
        this.initDefaultDataSource(env);
        this.initMultiDataSources(env);
        this.initDataSourcePlugin(env);
        this.initXmapperPlugin(env);
        this.initModelPreLoadPlugin(env);
        this.initEhcachePlugin(env);
        this.initSqlResourcePreloadPlugin(env);
        this.initTransactionPlugin(env);
        this.initProxyPlugin(env);
        return this.initPluginStarter();
    }

    private PluginStarter initPluginStarter() {
        PluginStarter pluginStarter = new PluginStarter(this.pluginList);
        pluginStarter.start();
        return pluginStarter;
    }

    private void initProxyPlugin(Environment env) {
        String[] clzArray;
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.proxy.");
        String clzList = propertyResolver.getProperty("class");
        if (StrKit.isBlank(clzList)) {
            return;
        }
        ProxyPlugin plugin = new ProxyPlugin();
        for (String clz : clzArray = clzList.split(",")) {
            if (!StrKit.isNotBlank(clz)) continue;
            IPlugin item = null;
            try {
                item = (IPlugin)Class.forName(clz.trim()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                GLog.error("\u521d\u59cb\u5316\u63d2\u4ef6\u5931\u8d25, clz: " + clz, e);
            }
            if (item == null) continue;
            plugin.addPlugin(item);
        }
        this.pluginList.add(plugin);
    }

    private void initDataSourcePlugin(Environment env) {
        DataSourcePlugin p = new DataSourcePlugin();
        p.setDataSourceWrapper(this.defaultDataSource);
        this.pluginList.add(p);
        Set<Map.Entry<String, DataSourceWrapper>> kvSets = this.multiDataSources.entrySet();
        for (Map.Entry<String, DataSourceWrapper> kv : kvSets) {
            DataSourcePlugin ptmp = new DataSourcePlugin();
            ptmp.setJdbcResourceName(kv.getKey());
            ptmp.setDataSourceWrapper(kv.getValue());
            this.pluginList.add(ptmp);
        }
    }

    private void initXmapperPlugin(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.xmapper.");
        String inited = propertyResolver.getProperty("inited");
        if (!"true".equalsIgnoreCase(inited)) {
            return;
        }
        GLog.debug("XmapperPlugin inited.", new Object[0]);
        String resourcePath = propertyResolver.getProperty("resourcePath");
        if (resourcePath == null || "".equals(resourcePath)) {
            resourcePath = "xmapper";
        }
        GLog.debug("XmapperPlugin resourcePath:{}", resourcePath);
        XmapperPlugin xmapperPlugin = new XmapperPlugin(resourcePath);
        this.pluginList.add(xmapperPlugin);
    }

    private void initModelPreLoadPlugin(Environment env) {
        String scanPackageList;
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.modelpreload.");
        String inited = propertyResolver.getProperty("inited");
        if (!"true".equalsIgnoreCase(inited)) {
            return;
        }
        GLog.debug("ModelPreloadPlugin inited.", new Object[0]);
        ModelPreloadPlugin mp = new ModelPreloadPlugin();
        String acmStrategy = propertyResolver.getProperty("acmStrategy");
        if (StrKit.isNotBlank(acmStrategy)) {
            mp.setAcmStrategyClass(acmStrategy);
        }
        if (StrKit.isNotBlank(scanPackageList = propertyResolver.getProperty("scanPackageList"))) {
            GLog.debug("ModelPreloadPlugin scanPackageList:{}", scanPackageList);
            String[] pkgArray = scanPackageList.split(",");
            mp.setScanPackageList(Arrays.asList(pkgArray));
        }
        this.pluginList.add(mp);
    }

    private void initEhcachePlugin(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.ehcache.");
        String inited = propertyResolver.getProperty("inited");
        if (!"true".equalsIgnoreCase(inited)) {
            return;
        }
        GLog.debug("EhcachePlugin inited.", new Object[0]);
        this.pluginList.add(new EhcachePlugin());
    }

    private void initSqlResourcePreloadPlugin(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.mirage.");
        String path = propertyResolver.getProperty("sqlpath");
        if (StrKit.isBlank(path)) {
            return;
        }
        GLog.debug("SqlResourcePreloadPlugin inited.", new Object[0]);
        String[] pathArray = path.split(",");
        List<String> pathList = Arrays.asList(pathArray);
        SqlResourcePreloadPlugin plugin = new SqlResourcePreloadPlugin(pathList);
        this.pluginList.add(plugin);
    }

    private void initTransactionPlugin(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.transaction.");
        String level = propertyResolver.getProperty("level");
        if (StrKit.isBlank(level)) {
            return;
        }
        GLog.debug("TransactionIsolationPlugin inited.", new Object[0]);
        int levelInt = Integer.parseInt(level);
        TransactionIsolationPlugin plugin = new TransactionIsolationPlugin(levelInt);
        this.pluginList.add(plugin);
    }

    private void initDefaultDataSource(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.datasource.default.");
        HashMap<String, Object> dsMap = new HashMap<String, Object>();
        dsMap.put("url", propertyResolver.getProperty("url"));
        dsMap.put("driver", propertyResolver.getProperty("driver"));
        dsMap.put("username", propertyResolver.getProperty("username"));
        dsMap.put("password", propertyResolver.getProperty("password"));
        dsMap.put("dbtype", propertyResolver.getProperty("dbtype"));
        Map<String, Object> extConfig = propertyResolver.getSubProperties("config.");
        this.defaultDataSource = this.buildDataSource(dsMap, extConfig);
    }

    private void initMultiDataSources(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.datasource.multi.");
        String dsPrefixs = propertyResolver.getProperty("names");
        if (dsPrefixs == null || "".equals(dsPrefixs)) {
            return;
        }
        for (String dsPrefix : dsPrefixs.split(",")) {
            Map<String, Object> dsMap = propertyResolver.getSubProperties(dsPrefix + ".");
            Map<String, Object> extConfig = propertyResolver.getSubProperties(dsPrefix + ".config.");
            DataSourceWrapper ds = this.buildDataSource(dsMap, extConfig);
            this.multiDataSources.put(dsPrefix, ds);
        }
    }
}

