/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.starter.common;

import cn.sylinx.hbatis.ds.DataSourceWrapper;
import cn.sylinx.hbatis.exception.HbatisException;
import cn.sylinx.hbatis.ext.mirage.plugin.SqlResourcePreloadPlugin;
import cn.sylinx.hbatis.ext.starter.common.RelaxedPropertyResolver;
import cn.sylinx.hbatis.ext.starter.pool.DataSourceWrapperFactory;
import cn.sylinx.hbatis.ext.xmapper.plugin.XmapperPlugin;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.IPlugin;
import cn.sylinx.hbatis.plugin.PluginStarter;
import cn.sylinx.hbatis.plugin.datasource.DataSourcePlugin;
import cn.sylinx.hbatis.plugin.ehcache.EhcachePlugin;
import cn.sylinx.hbatis.plugin.model.ModelPreloadPlugin;
import cn.sylinx.hbatis.plugin.proxy.ProxyPlugin;
import cn.sylinx.hbatis.plugin.transaction.TransactionIsolationPlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class StarterBean {
    private String config = "/hbatis.properties";
    private Properties p;
    private DataSourceWrapper defaultDataSource;
    private Map<String, DataSourceWrapper> multiDataSources = new HashMap<String, DataSourceWrapper>();
    private List<IPlugin> pluginList = new ArrayList<IPlugin>();
    private PluginStarter pluginStarter;

    public StarterBean() {
        this(null);
    }

    public StarterBean(String config) {
        if (config != null && !"".equals(config)) {
            this.config = config;
        }
        this.init();
    }

    private void init() {
        this.p = new Properties();
        try {
            this.p.load(StarterBean.class.getResourceAsStream(this.config));
        }
        catch (IOException e) {
            throw new HbatisException(e);
        }
    }

    private void initHbatis() {
        this.initDefaultDataSource(this.p);
        this.initMultiDataSources(this.p);
        this.initDataSourcePlugin(this.p);
        this.initXmapperPlugin(this.p);
        this.initModelPreLoadPlugin(this.p);
        this.initEhcachePlugin(this.p);
        this.initSqlResourcePreloadPlugin(this.p);
        this.initTransactionPlugin(this.p);
        this.initProxyPlugin(this.p);
    }

    public void addPlugin(IPlugin plugin) {
        this.pluginList.add(plugin);
    }

    public void start() {
        String initKey = "hbatis.init";
        String initStr = this.p.getProperty(initKey, "false");
        boolean init = Boolean.valueOf(initStr);
        if (!init) {
            GLog.info("hbatis \u6ca1\u6709\u88ab\u521d\u59cb\u5316\uff0c\u8bf7\u786e\u8ba4hbatis.init=true\u3002", new Object[0]);
            return;
        }
        this.initHbatis();
        this.initPluginStarter();
    }

    private void initPluginStarter() {
        this.pluginStarter = new PluginStarter(this.pluginList);
        this.pluginStarter.start();
    }

    private void initDataSourcePlugin(Properties p) {
        DataSourcePlugin dsp = new DataSourcePlugin();
        dsp.setDataSourceWrapper(this.defaultDataSource);
        this.addPlugin(dsp);
        Set<Map.Entry<String, DataSourceWrapper>> kvSets = this.multiDataSources.entrySet();
        for (Map.Entry<String, DataSourceWrapper> kv : kvSets) {
            DataSourcePlugin ptmp = new DataSourcePlugin();
            ptmp.setJdbcResourceName(kv.getKey());
            ptmp.setDataSourceWrapper(kv.getValue());
            this.addPlugin(ptmp);
        }
    }

    private void initXmapperPlugin(Properties p) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver(p, "hbatis.plugin.xmapper.");
        String inited = propertyResolver.getProperty("inited");
        if (!"true".equalsIgnoreCase(inited)) {
            return;
        }
        GLog.debug("XmapperPlugin inited.", new Object[0]);
        String resourcePath = propertyResolver.getProperty("resourcePath");
        if (resourcePath == null || "".equals(resourcePath)) {
            resourcePath = "xmapper";
        }
        GLog.debug("XmapperPlugin resourcePath:{}", resourcePath);
        XmapperPlugin xmapperPlugin = new XmapperPlugin(resourcePath);
        this.addPlugin(xmapperPlugin);
    }

    private void initModelPreLoadPlugin(Properties p) {
        String scanPackageList;
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver(p, "hbatis.plugin.modelpreload.");
        String inited = propertyResolver.getProperty("inited");
        if (!"true".equalsIgnoreCase(inited)) {
            return;
        }
        GLog.debug("ModelPreloadPlugin inited.", new Object[0]);
        ModelPreloadPlugin mp = new ModelPreloadPlugin();
        String acmStrategy = propertyResolver.getProperty("acmStrategy");
        if (StrKit.isNotBlank(acmStrategy)) {
            mp.setAcmStrategyClass(acmStrategy);
        }
        if (StrKit.isNotBlank(scanPackageList = propertyResolver.getProperty("scanPackageList"))) {
            GLog.debug("ModelPreloadPlugin scanPackageList:{}", scanPackageList);
            String[] pkgArray = scanPackageList.split(",");
            mp.setScanPackageList(Arrays.asList(pkgArray));
        }
        this.addPlugin(mp);
    }

    private void initSqlResourcePreloadPlugin(Properties p) {
        String path = p.getProperty("hbatis.plugin.mirage.sqlpath");
        if (StrKit.isBlank(path)) {
            return;
        }
        String[] pathArray = path.split(",");
        List<String> pathList = Arrays.asList(pathArray);
        SqlResourcePreloadPlugin plugin = new SqlResourcePreloadPlugin(pathList);
        this.addPlugin(plugin);
    }

    private void initTransactionPlugin(Properties p) {
        String level = p.getProperty("hbatis.plugin.transaction.level");
        if (StrKit.isBlank(level)) {
            return;
        }
        int levelInt = Integer.parseInt(level);
        TransactionIsolationPlugin plugin = new TransactionIsolationPlugin(levelInt);
        this.addPlugin(plugin);
    }

    private void initProxyPlugin(Properties p) {
        String[] clzArray;
        String clzList = p.getProperty("hbatis.plugin.proxy.class");
        if (StrKit.isBlank(clzList)) {
            return;
        }
        ProxyPlugin plugin = new ProxyPlugin();
        for (String clz : clzArray = clzList.split(",")) {
            if (!StrKit.isNotBlank(clz)) continue;
            IPlugin item = null;
            try {
                item = (IPlugin)Class.forName(clz.trim()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                GLog.error("\u521d\u59cb\u5316\u63d2\u4ef6\u5931\u8d25, clz: " + clz, e);
            }
            if (item == null) continue;
            plugin.addPlugin(item);
        }
        this.addPlugin(plugin);
    }

    private void initEhcachePlugin(Properties p) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver(p, "hbatis.plugin.ehcache.");
        String inited = propertyResolver.getProperty("inited");
        if (!"true".equalsIgnoreCase(inited)) {
            return;
        }
        GLog.debug("EhcachePlugin inited.", new Object[0]);
        this.addPlugin(new EhcachePlugin());
    }

    private void initDefaultDataSource(Properties p) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver(p, "hbatis.datasource.default.");
        HashMap<String, Object> dsMap = new HashMap<String, Object>();
        dsMap.put("url", propertyResolver.getProperty("url"));
        dsMap.put("driver", propertyResolver.getProperty("driver"));
        dsMap.put("username", propertyResolver.getProperty("username"));
        dsMap.put("password", propertyResolver.getProperty("password"));
        dsMap.put("dbtype", propertyResolver.getProperty("dbtype"));
        Map<String, Object> extConfig = propertyResolver.getSubProperties("config.");
        this.defaultDataSource = this.buildDataSource(dsMap, extConfig);
    }

    private void initMultiDataSources(Properties p) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver(p, "hbatis.datasource.multi.");
        String dsPrefixs = propertyResolver.getProperty("names");
        if (dsPrefixs == null || "".equals(dsPrefixs)) {
            return;
        }
        for (String dsPrefix : dsPrefixs.split(",")) {
            Map<String, Object> dsMap = propertyResolver.getSubProperties(dsPrefix + ".");
            Map<String, Object> extConfig = propertyResolver.getSubProperties(dsPrefix + ".config.");
            DataSourceWrapper ds = this.buildDataSource(dsMap, extConfig);
            this.multiDataSources.put(dsPrefix, ds);
        }
    }

    private DataSourceWrapper buildDataSource(Map<String, Object> dsMap, Map<String, Object> extConfig) {
        return DataSourceWrapperFactory.buildDataSource(dsMap, extConfig);
    }
}

