/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.db.dialect;

import cn.sylinx.hbatis.db.dialect.Db2Dialect;
import cn.sylinx.hbatis.db.dialect.DbType;
import cn.sylinx.hbatis.db.dialect.DerbyDialect;
import cn.sylinx.hbatis.db.dialect.Dialect;
import cn.sylinx.hbatis.db.dialect.H2Dialect;
import cn.sylinx.hbatis.db.dialect.MysqlDialect;
import cn.sylinx.hbatis.db.dialect.OracleDialect;
import cn.sylinx.hbatis.db.dialect.PostgreSQLDialect;
import cn.sylinx.hbatis.db.dialect.SqlServerDialect;

public class DialectFatory {
    private static DialectFatory INSTANCE = new DialectFatory();

    public static DialectFatory get() {
        return INSTANCE;
    }

    public Dialect createDialect(DbType dbType) {
        switch (dbType) {
            case MYSQL: {
                return new MysqlDialect();
            }
            case ORACLE: {
                return new OracleDialect();
            }
            case SQLSERVER: {
                return new SqlServerDialect();
            }
            case DERBY: {
                return new DerbyDialect();
            }
            case POSTGRESQL: {
                return new PostgreSQLDialect();
            }
            case DB2: {
                return new Db2Dialect();
            }
            case H2: {
                return new H2Dialect();
            }
        }
        return new MysqlDialect();
    }
}

