/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.plugin.model;

import cn.sylinx.hbatis.db.mapper.MappingFileManager;
import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.db.mapper.acm.AcmStrategy;
import cn.sylinx.hbatis.db.mapper.anno.AttributeColumnMapping;
import cn.sylinx.hbatis.db.mapper.anno.ColumnDesc;
import cn.sylinx.hbatis.db.mapper.anno.PrimaryKey;
import cn.sylinx.hbatis.db.mapper.anno.Table;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.model.ModelConst;
import cn.sylinx.hbatis.plugin.model.ModelFabric;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public enum ModelCacheManager {
    ME;

    private Map<String, ModelFabric> cached = new ConcurrentHashMap<String, ModelFabric>();

    public static ModelCacheManager get() {
        return ME;
    }

    public ModelFabric getModelFabric(String clzStr) {
        Class<?> clz = null;
        try {
            clz = Class.forName(clzStr);
            return this.getModelFabric(clz);
        }
        catch (ClassNotFoundException e) {
            GLog.error("getModelFabric error:", e);
            return null;
        }
    }

    public ModelFabric getModelFabric(Class<?> clz) {
        ModelFabric mf = this.cached.get(clz.getName());
        if (mf == null) {
            try {
                mf = this.cachedOneModel(clz);
                GLog.debug("\u6dfb\u52a0model[{}]\u81f3\u7f13\u5b58", clz.getName());
                this.cached.put(clz.getName(), mf);
            }
            catch (Exception e) {
                GLog.error("cachedOneModel error, clz:" + clz.getName(), e);
            }
        }
        return mf;
    }

    public void init(Set<String> clzSets) {
        if (clzSets == null || clzSets.isEmpty()) {
            return;
        }
        for (String clzStr : clzSets) {
            try {
                Class<?> clz = Class.forName(clzStr);
                Table t = clz.getDeclaredAnnotation(Table.class);
                if (t == null) continue;
                ModelFabric mf = this.cachedOneModel(clz);
                GLog.debug("\u6dfb\u52a0model[{}]\u81f3\u7f13\u5b58", clzStr);
                this.cached.put(clzStr, mf);
            }
            catch (Exception e) {
                GLog.error("init error", e);
            }
        }
    }

    private ModelFabric cachedOneModel(Class<?> clz) throws Exception {
        AttributeColumnMapping mapping = clz.getAnnotation(AttributeColumnMapping.class);
        Table table = clz.getAnnotation(Table.class);
        PrimaryKey pk = clz.getAnnotation(PrimaryKey.class);
        Map<String, Field> fieldMap = ModelBuilder.getObjectAllFieldsMap(clz);
        List<Field> fields = ModelBuilder.getObjectAllFields(clz);
        ModelFabric mf = new ModelFabric();
        mf.setClz(clz);
        mf.setFieldMap(fieldMap);
        mf.setFields(fields);
        mf.setMapping(mapping);
        mf.setPrimaryKey(pk);
        mf.setTable(table);
        HashMap<String, ColumnDesc> fieldDesc = new HashMap<String, ColumnDesc>();
        for (Field f : fields) {
            ColumnDesc cd = f.getAnnotation(ColumnDesc.class);
            if (cd == null) continue;
            fieldDesc.put(f.getName(), cd);
        }
        mf.setFieldDesc(fieldDesc);
        HashMap<String, String> attrMapping = new HashMap<String, String>();
        boolean useAcmStrategy = false;
        AcmStrategy globalAcmStrategy = ModelConst.ME.getAcmStrategy();
        if (globalAcmStrategy == null) {
            String acmStrategy;
            String string = acmStrategy = mapping != null ? mapping.acmStrategy() : null;
            if (acmStrategy != null && !"".equals(acmStrategy)) {
                Class<?> acmStrategyClz = Class.forName(acmStrategy);
                Object inst = acmStrategyClz.newInstance();
                if (inst instanceof AcmStrategy) {
                    useAcmStrategy = true;
                    AcmStrategy as = (AcmStrategy)inst;
                    attrMapping.putAll(as.createAttrMapping(mf));
                } else {
                    GLog.error("{}\u4e0d\u662f\u6620\u5c04\u7b56\u7565", acmStrategy);
                    useAcmStrategy = false;
                }
            }
        } else {
            useAcmStrategy = true;
            attrMapping.putAll(globalAcmStrategy.createAttrMapping(mf));
        }
        if (!useAcmStrategy) {
            boolean isUseAttribute;
            boolean bl = isUseAttribute = mapping == null || mapping.useAttribute();
            if (isUseAttribute) {
                Set<String> attrs = fieldMap.keySet();
                for (String attr : attrs) {
                    attrMapping.put(attr, attr);
                }
            } else {
                String[] paires = mapping.value();
                for (String paire : paires) {
                    String[] p = paire.split(":");
                    attrMapping.put(p[0], p[1]);
                }
                if (attrMapping.isEmpty()) {
                    attrMapping.putAll(ModelCacheManager.getMappingFromFileJavaToDb(mapping.mappingFile()));
                }
            }
        }
        mf.setAttrMapping(attrMapping);
        return mf;
    }

    private static Map<String, String> getMappingFromFileJavaToDb(String resource) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        if (StrKit.isBlank(resource)) {
            return mapping;
        }
        Properties p = MappingFileManager.get().getMappingFile(resource);
        Set<Object> keys = p.keySet();
        for (Object key : keys) {
            String value = p.getProperty(key.toString());
            mapping.put(key.toString(), value);
        }
        return mapping;
    }

    public void clear() {
        Set<Map.Entry<String, ModelFabric>> entries = this.cached.entrySet();
        for (Map.Entry<String, ModelFabric> item : entries) {
            item.getValue().clear();
        }
        this.cached.clear();
    }
}

