/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.io;

import cn.sylinx.hbatis.io.Resources;
import cn.sylinx.hbatis.kit.StrKit;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;

public class ClasspathResourceScanner {
    private String path;
    private String postfix;

    public ClasspathResourceScanner(String path) {
        this(path, null, false, null);
    }

    public ClasspathResourceScanner(String path, boolean isPackage) {
        this(path, null, isPackage);
    }

    public ClasspathResourceScanner(String path, String postfix) {
        this(path, postfix, false);
    }

    public ClasspathResourceScanner(String path, String postfix, boolean isPackage) {
        this(path, postfix, isPackage, null);
    }

    public ClasspathResourceScanner(String path, String postfix, boolean isPackage, ClassLoader cl) {
        this.path = path;
        this.postfix = postfix;
        if (this.postfix == null) {
            this.postfix = ".xml";
        }
        if (isPackage) {
            this.path = path.replaceAll("\\.", "/");
        }
    }

    public List<String> getResourceNameList() throws Exception {
        return this.doScan(this.path, new ArrayList<String>());
    }

    private List<String> doScan(String baseFolder, List<String> nameList) throws Exception {
        List<URL> urlList = Resources.getResourceURLs(baseFolder);
        for (URL url : urlList) {
            String filePath = StrKit.getRootPath(url);
            List<String> names = null;
            boolean isJarFile = this.isJarFile(filePath);
            names = isJarFile ? this.readFromJarFile(filePath, baseFolder) : this.readFromDirectory(filePath);
            if (names == null) {
                return null;
            }
            for (String name : names) {
                if (this.isMatchFile(name)) {
                    String tmpName = null;
                    tmpName = isJarFile ? name : baseFolder + "/" + name;
                    if (nameList.contains(tmpName)) continue;
                    nameList.add(tmpName);
                    continue;
                }
                this.doScan(baseFolder + "/" + name, nameList);
            }
        }
        return nameList;
    }

    private boolean isJarFile(String name) {
        return name.endsWith(".jar");
    }

    private boolean isMatchFile(String name) {
        return name.endsWith(this.postfix);
    }

    private List<String> readFromDirectory(String path) {
        File f = new File(path);
        String[] names = f.list();
        if (names == null) {
            return null;
        }
        return Arrays.asList(names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFromJarFile(String jarPath, String splashedPackageName) throws Exception {
        try (ZipInputStream jarIn = null;){
            jarIn = new JarInputStream(new FileInputStream(jarPath));
            JarEntry entry = ((JarInputStream)jarIn).getNextJarEntry();
            ArrayList<String> nameList = new ArrayList<String>();
            while (entry != null) {
                String name = entry.getName();
                if (name.startsWith(splashedPackageName) && this.isMatchFile(name)) {
                    nameList.add(name);
                }
                entry = ((JarInputStream)jarIn).getNextJarEntry();
            }
            ArrayList<String> arrayList = nameList;
            return arrayList;
        }
    }
}

