/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.starter.springboot;

import cn.sylinx.hbatis.db.dialect.DbType;
import cn.sylinx.hbatis.db.dialect.sql.SqlBuilderFactory;
import cn.sylinx.hbatis.ext.mirage.plugin.SqlResourcePreloadPlugin;
import cn.sylinx.hbatis.ext.starter.springboot.RelaxedPropertyResolver;
import cn.sylinx.hbatis.ext.xmapper.plugin.XmapperPlugin;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.IPlugin;
import cn.sylinx.hbatis.plugin.PluginStarter;
import cn.sylinx.hbatis.plugin.datasource.DataSourcePlugin;
import cn.sylinx.hbatis.plugin.ehcache.EhcachePlugin;
import cn.sylinx.hbatis.plugin.model.ModelPreloadPlugin;
import cn.sylinx.hbatis.plugin.proxy.ProxyPlugin;
import cn.sylinx.hbatis.plugin.transaction.TransactionIsolationPlugin;
import com.alibaba.druid.pool.DruidDataSource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

@Configuration
@ConditionalOnClass(value={DruidDataSource.class})
public class HbatisStarter
implements EnvironmentAware,
DisposableBean {
    private DruidDataSource defaultDataSource;
    private Map<String, DruidDataSource> multiDataSources = new HashMap<String, DruidDataSource>();
    private List<IPlugin> pluginList = new ArrayList<IPlugin>();
    private PluginStarter pluginStarter;

    private DruidDataSource buildDataSource(Map<String, Object> dsMap) {
        Object dcnObject = dsMap.get("driver");
        String driverClassName = null;
        if (dcnObject != null && !"".equals(dcnObject.toString().trim())) {
            driverClassName = dcnObject.toString();
        }
        Object filtersObject = dsMap.get("filters");
        String filters = null;
        if (filtersObject != null && !"".equals(filtersObject.toString().trim())) {
            filters = filtersObject.toString();
        }
        String dbType = dsMap.get("dbtype").toString();
        DruidDataSource cds = new DruidDataSource();
        cds.setUrl(dsMap.get("url").toString());
        cds.setDriverClassName(driverClassName);
        cds.setUsername(dsMap.get("username").toString());
        cds.setPassword(dsMap.get("password").toString());
        cds.setInitialSize(Integer.valueOf(dsMap.get("initalSize").toString()).intValue());
        cds.setMinIdle(Integer.valueOf(dsMap.get("minIdle").toString()).intValue());
        cds.setMaxActive(Integer.valueOf(dsMap.get("maxActive").toString()).intValue());
        cds.setDbType(dbType);
        cds.setTestWhileIdle(true);
        cds.setValidationQuery(this.getValidateQuery(dbType));
        try {
            cds.setFilters(filters);
        }
        catch (SQLException e) {
            GLog.error("set filters error", e);
        }
        return cds;
    }

    private String getValidateQuery(String dbtype) {
        DbType dt = DbType.getDbType(dbtype);
        return SqlBuilderFactory.get().getSqlBuilder(dt).buildValidateQuery();
    }

    public void setEnvironment(Environment env) {
        String initKey = "hbatis.init";
        boolean init = (Boolean)env.getProperty(initKey, Boolean.class, (Object)false);
        if (!init) {
            GLog.info("hbatis\u4e2a\u6027\u914d\u7f6e\u6570\u636e\u6e90\u6ca1\u6709\u88ab\u521d\u59cb\u5316\uff0c\u8bf7\u786e\u8ba4hbatis.init=true\u3002", new Object[0]);
            return;
        }
        this.initDefaultDataSource(env);
        this.initMultiDataSources(env);
        this.initDataSourcePlugin(env);
        this.initXmapperPlugin(env);
        this.initModelPreLoadPlugin(env);
        this.initEhcachePlugin(env);
        this.initSqlResourcePreloadPlugin(env);
        this.initTransactionPlugin(env);
        this.initProxyPlugin(env);
        this.initPluginStarter();
    }

    private void initPluginStarter() {
        this.pluginStarter = new PluginStarter(this.pluginList);
        this.pluginStarter.start();
    }

    private void initProxyPlugin(Environment env) {
        String[] clzArray;
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.proxy.");
        String clzList = propertyResolver.getProperty("class");
        if (StrKit.isBlank(clzList)) {
            return;
        }
        ProxyPlugin plugin = new ProxyPlugin();
        for (String clz : clzArray = clzList.split(",")) {
            if (!StrKit.isNotBlank(clz)) continue;
            IPlugin item = null;
            try {
                item = (IPlugin)Class.forName(clz.trim()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                GLog.error("\u521d\u59cb\u5316\u63d2\u4ef6\u5931\u8d25, clz: " + clz, e);
            }
            if (item == null) continue;
            plugin.addPlugin(item);
        }
        this.pluginList.add(plugin);
    }

    private void initDataSourcePlugin(Environment env) {
        DataSourcePlugin p = new DataSourcePlugin();
        p.setDataSource((DataSource)this.defaultDataSource);
        p.setDbType(this.defaultDataSource.getDbType());
        this.pluginList.add(p);
        Set<Map.Entry<String, DruidDataSource>> kvSets = this.multiDataSources.entrySet();
        for (Map.Entry<String, DruidDataSource> kv : kvSets) {
            DataSourcePlugin ptmp = new DataSourcePlugin();
            ptmp.setDataSource((DataSource)kv.getValue());
            ptmp.setJdbcResourceName(kv.getKey());
            ptmp.setDbType(kv.getValue().getDbType());
            this.pluginList.add(ptmp);
        }
    }

    private void initXmapperPlugin(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.xmapper.");
        String inited = propertyResolver.getProperty("inited");
        if (!"true".equalsIgnoreCase(inited)) {
            return;
        }
        GLog.debug("XmapperPlugin inited.", new Object[0]);
        String resourcePath = propertyResolver.getProperty("resourcePath");
        if (resourcePath == null || "".equals(resourcePath)) {
            resourcePath = "xmapper";
        }
        GLog.debug("XmapperPlugin resourcePath:{}", resourcePath);
        XmapperPlugin xmapperPlugin = new XmapperPlugin(resourcePath);
        this.pluginList.add(xmapperPlugin);
    }

    private void initModelPreLoadPlugin(Environment env) {
        String scanPackageList;
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.modelpreload.");
        String inited = propertyResolver.getProperty("inited");
        if (!"true".equalsIgnoreCase(inited)) {
            return;
        }
        GLog.debug("ModelPreloadPlugin inited.", new Object[0]);
        ModelPreloadPlugin mp = new ModelPreloadPlugin();
        String acmStrategy = propertyResolver.getProperty("acmStrategy");
        if (StrKit.isNotBlank(acmStrategy)) {
            mp.setAcmStrategyClass(acmStrategy);
        }
        if (StrKit.isNotBlank(scanPackageList = propertyResolver.getProperty("scanPackageList"))) {
            GLog.debug("ModelPreloadPlugin scanPackageList:{}", scanPackageList);
            String[] pkgArray = scanPackageList.split(",");
            mp.setScanPackageList(Arrays.asList(pkgArray));
        }
        this.pluginList.add(mp);
    }

    private void initEhcachePlugin(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.ehcache.");
        String inited = propertyResolver.getProperty("inited");
        if (!"true".equalsIgnoreCase(inited)) {
            return;
        }
        GLog.debug("EhcachePlugin inited.", new Object[0]);
        this.pluginList.add(new EhcachePlugin());
    }

    private void initSqlResourcePreloadPlugin(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.mirage.");
        String path = propertyResolver.getProperty("sqlpath");
        if (StrKit.isBlank(path)) {
            return;
        }
        GLog.debug("SqlResourcePreloadPlugin inited.", new Object[0]);
        String[] pathArray = path.split(",");
        List<String> pathList = Arrays.asList(pathArray);
        SqlResourcePreloadPlugin plugin = new SqlResourcePreloadPlugin(pathList);
        this.pluginList.add(plugin);
    }

    private void initTransactionPlugin(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.plugin.transaction.");
        String level = propertyResolver.getProperty("level");
        if (StrKit.isBlank(level)) {
            return;
        }
        GLog.debug("TransactionIsolationPlugin inited.", new Object[0]);
        int levelInt = Integer.parseInt(level);
        TransactionIsolationPlugin plugin = new TransactionIsolationPlugin(levelInt);
        this.pluginList.add(plugin);
    }

    private void initDefaultDataSource(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.datasource.default.");
        HashMap<String, Object> dsMap = new HashMap<String, Object>();
        dsMap.put("url", propertyResolver.getProperty("url"));
        dsMap.put("driver", propertyResolver.getProperty("driver"));
        dsMap.put("username", propertyResolver.getProperty("username"));
        dsMap.put("password", propertyResolver.getProperty("password"));
        dsMap.put("initalSize", propertyResolver.getProperty("initalSize", "2"));
        dsMap.put("minIdle", propertyResolver.getProperty("minIdle", "1"));
        dsMap.put("maxActive", propertyResolver.getProperty("maxActive", "20"));
        dsMap.put("dbtype", propertyResolver.getProperty("dbtype"));
        dsMap.put("filters", propertyResolver.getProperty("filters"));
        this.defaultDataSource = this.buildDataSource(dsMap);
    }

    private void initMultiDataSources(Environment env) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)env, "hbatis.datasource.multi.");
        String dsPrefixs = propertyResolver.getProperty("names");
        if (dsPrefixs == null || "".equals(dsPrefixs)) {
            return;
        }
        for (String dsPrefix : dsPrefixs.split(",")) {
            Map<String, Object> dsMap = propertyResolver.getSubProperties(dsPrefix + ".");
            DruidDataSource ds = this.buildDataSource(dsMap);
            this.multiDataSources.put(dsPrefix, ds);
        }
    }

    public void destroy() throws Exception {
        if (this.pluginStarter != null) {
            this.pluginStarter.stop();
        }
    }
}

