/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.db.dialect.sql;

import cn.sylinx.hbatis.db.common.FS;
import cn.sylinx.hbatis.db.common.FluentSqlParams;
import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.exception.HbatisException;
import cn.sylinx.hbatis.ext.model.Model;
import cn.sylinx.hbatis.kit.Pair;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.kit.Tuple;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.model.ModelFabric;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface SqlBuilder {
    public Tuple buildPaginatorSql(String var1, int var2, int var3);

    public <T> Tuple buildDeleteSQL(T var1);

    public <T> Tuple buildInsertSQL(T var1);

    public <T> Tuple buildUpdateSQL(T var1);

    public Tuple buildDeleteByFieldSQL(List<Pair> var1, Class<?> var2);

    public Tuple buildQueryByFieldSQL(List<Pair> var1, Class<?> var2);

    public Tuple buildQueryByFieldSQL(List<Pair> var1, Class<?> var2, String[] var3);

    public String buildSimpleQuery(Class<?> var1);

    public String buildSimpleQuery(Class<?> var1, String[] var2);

    public String getTable(Class<?> var1);

    public String getTableColumn(Class<?> var1, String var2);

    public String[] buildCreateTableDDL(Class<?> var1);

    public String[] buildModifyTableColumnDDL(Class<?> var1, String var2);

    public String[] buildAddTableColumnDDL(Class<?> var1, String var2);

    public String buildValidateQuery();

    default public Tuple buildSelectSQL(FS<?> fluentSql) {
        FluentSqlParams<?> sqlParams = fluentSql.build();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT");
        if (sqlParams.isDistinct()) {
            sql.append(" DISTINCT");
        }
        if (StrKit.isNotBlank(sqlParams.getSelectColumns())) {
            sql.append(' ').append(sqlParams.getSelectColumns()).append(' ');
        } else if (sqlParams.getExcludedColumns() != null && !sqlParams.getExcludedColumns().isEmpty()) {
            sql.append(' ').append(ModelBuilder.buildColumnsByExcluded(sqlParams.getModelClass(), sqlParams.getExcludedColumns())).append(' ');
        } else {
            sql.append(" * ");
        }
        sql.append("FROM ").append(sqlParams.getTableName());
        if (sqlParams.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(sqlParams.getConditionSQL().substring(5));
        }
        if (StrKit.isNotBlank(sqlParams.getOrderBy())) {
            sql.append(" ORDER BY").append(sqlParams.getOrderBy());
        }
        int len = sqlParams.getParamValues() == null || sqlParams.getParamValues().isEmpty() ? 0 : sqlParams.getParamValues().size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            sqlParams.getParamValues().toArray(params);
        }
        GLog.debug("sql:{}, params:{}", sql.toString(), params);
        return Tuple.apply(sql.toString(), params, sqlParams.getModelClass());
    }

    default public Pair buildUpdateSQL(FS<?> fluentSql) {
        FluentSqlParams<?> sqlParams = fluentSql.build();
        ArrayList<Object> paramsUpdate = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(sqlParams.getTableName()).append(" SET ");
        StringBuilder setSQL = new StringBuilder();
        if (null != sqlParams.getUpdateColumns() && !sqlParams.getUpdateColumns().isEmpty()) {
            sqlParams.getUpdateColumns().forEach((key, value) -> {
                setSQL.append((String)key).append(" = ?, ");
                paramsUpdate.add(value);
            });
        } else if (null != sqlParams.getModel()) {
            ModelFabric mf = ModelBuilder.getModelFabric(sqlParams.getModelClass());
            List<Field> fields = mf.getFields();
            Map<String, String> attrs = mf.getAttrMapping();
            Set<Object> nullableSets = new HashSet();
            if (sqlParams.getModel() instanceof Model) {
                nullableSets = ((Model)sqlParams.getModel()).getNullableFields();
            }
            try {
                for (Field field : fields) {
                    field.setAccessible(true);
                    String fieldName = field.getName();
                    Object v = field.get(sqlParams.getModel());
                    String f = attrs.get(fieldName);
                    if (f == null) continue;
                    boolean nullable = nullableSets.contains(fieldName);
                    if (v != null) {
                        setSQL.append(f).append(" = ?, ");
                        paramsUpdate.add(v);
                        continue;
                    }
                    if (!nullable) continue;
                    setSQL.append(f).append(" = NULL, ");
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new HbatisException("illegal argument or Access:", e);
            }
        }
        sql.append(setSQL.substring(0, setSQL.length() - 2));
        if (sqlParams.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(sqlParams.getConditionSQL().substring(5));
        }
        ArrayList<Object> paramsListFinal = new ArrayList<Object>();
        List<Object> paramsListPre = sqlParams.getParamValues();
        if (paramsListPre == null) {
            paramsListPre = new ArrayList<Object>();
        }
        paramsListFinal.addAll(paramsUpdate);
        paramsListFinal.addAll(paramsListPre);
        int len = paramsListFinal.size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            paramsListFinal.toArray(params);
        }
        GLog.debug("sql:{}, params:{}", sql.toString(), params);
        return Pair.of(sql.toString(), params);
    }

    default public Pair buildInsertSQL(FS<?> fluentSql) {
        FluentSqlParams<?> sqlParams = fluentSql.build();
        StringBuilder columnNames = new StringBuilder();
        StringBuilder placeholder = new StringBuilder();
        ArrayList<Object> insertParams = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(sqlParams.getTableName());
        boolean hasField = false;
        if (null != sqlParams.getUpdateColumns() && !sqlParams.getUpdateColumns().isEmpty()) {
            Map<String, Object> uc = sqlParams.getUpdateColumns();
            Set<Map.Entry<String, Object>> entrySets = uc.entrySet();
            for (Map.Entry<String, Object> entry : entrySets) {
                columnNames.append(",").append(entry.getKey());
                placeholder.append(",?");
                insertParams.add(entry.getValue());
                hasField = true;
            }
        } else if (null != sqlParams.getModel()) {
            ModelFabric mf = ModelBuilder.getModelFabric(sqlParams.getModelClass());
            List<Field> fields = mf.getFields();
            Map<String, String> attrs = mf.getAttrMapping();
            try {
                for (Field field : fields) {
                    field.setAccessible(true);
                    String fieldName = field.getName();
                    Object v = field.get(sqlParams.getModel());
                    String f = attrs.get(fieldName);
                    if (f == null || v == null) continue;
                    columnNames.append(",").append(f);
                    placeholder.append(",?");
                    insertParams.add(v);
                    hasField = true;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new HbatisException("illegal argument or Access:", e);
            }
        }
        if (!hasField) {
            throw new HbatisException("no insert field detected");
        }
        sql.append("(").append(columnNames.substring(1)).append(")").append(" VALUES (").append(placeholder.substring(1)).append(")");
        ArrayList<Object> paramsListFinal = new ArrayList<Object>();
        paramsListFinal.addAll(insertParams);
        int len = paramsListFinal.size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            paramsListFinal.toArray(params);
        }
        GLog.debug("sql:{}, params:{}", sql.toString(), params);
        return Pair.of(sql.toString(), params);
    }

    default public Pair buildDeleteSQL(FS<?> fluentSql) {
        FluentSqlParams<?> sqlParams = fluentSql.build();
        ArrayList<Object> paramsDelete = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(sqlParams.getTableName());
        if (sqlParams.getConditionSQL().length() > 0) {
            sql.append(" WHERE ").append(sqlParams.getConditionSQL().substring(5));
            List<Object> paramsListPre = sqlParams.getParamValues();
            if (paramsListPre == null) {
                paramsListPre = new ArrayList<Object>();
            }
            paramsDelete.addAll(paramsListPre);
        } else if (null != sqlParams.getModel()) {
            StringBuilder columnNames = new StringBuilder();
            ModelFabric mf = ModelBuilder.getModelFabric(sqlParams.getModelClass());
            List<Field> fields = mf.getFields();
            Map<String, String> attrs = mf.getAttrMapping();
            try {
                for (Field field : fields) {
                    field.setAccessible(true);
                    String fieldName = field.getName();
                    Object v = field.get(sqlParams.getModel());
                    String f = attrs.get(fieldName);
                    if (f == null || v == null) continue;
                    columnNames.append(f).append(" = ? and ");
                    paramsDelete.add(v);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new HbatisException("illegal argument or Access:", e);
            }
            if (columnNames.length() > 0) {
                sql.append(" WHERE ").append(columnNames.substring(0, columnNames.length() - 5));
            }
        }
        ArrayList<Object> paramsListFinal = new ArrayList<Object>();
        paramsListFinal.addAll(paramsDelete);
        int len = paramsListFinal.size();
        Object[] params = null;
        if (len > 0) {
            params = new Object[len];
            paramsListFinal.toArray(params);
        }
        GLog.debug("sql:{}, params:{}", sql.toString(), params);
        return Pair.of(sql.toString(), params);
    }
}

