/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.db.common;

import cn.sylinx.hbatis.db.common.FluentSqlParams;
import cn.sylinx.hbatis.db.common.OrderBy;
import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.db.mapper.anno.PrimaryKey;
import cn.sylinx.hbatis.exception.HbatisException;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.model.ModelFabric;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FS<T> {
    protected Class<T> modelClass;
    protected StringBuilder conditionSQL = new StringBuilder();
    protected StringBuilder orderBySQL = new StringBuilder();
    protected List<String> excludedColumns = new ArrayList<String>(8);
    protected List<Object> paramValues = new ArrayList<Object>(8);
    protected Map<String, Object> updateColumns = new LinkedHashMap<String, Object>(8);
    protected String selectColumns;
    protected boolean distinct = false;
    protected String[] primaryKeyColumn;
    protected String tableName;
    protected Map<String, String> attrs = null;
    protected T model;
    protected String preEscape;
    protected String postEscape;

    public static <T> FS<T> of(Class<T> modelClass) {
        return new FS<T>().init(modelClass);
    }

    protected String[] getEscape() {
        return new String[]{"", ""};
    }

    public FS<T> init(Class<T> modelClass) {
        this.parse(modelClass);
        return this;
    }

    public FluentSqlParams<T> build() {
        this.beforeCheck();
        return FluentSqlParams.builder().conditionSQL(this.conditionSQL).modelClass(this.modelClass).orderBy(this.orderBySQL.toString()).excludedColumns(this.excludedColumns).paramValues(this.paramValues).updateColumns(this.updateColumns).selectColumns(this.selectColumns).primaryKeyColumn(this.primaryKeyColumn).tableName(this.tableName).model(this.model).distinct(this.distinct).build();
    }

    public FS<T> parse(Class<T> modelClass) {
        String[] stringArray;
        String[] escapes = this.getEscape();
        this.preEscape = escapes[0];
        this.postEscape = escapes[1];
        this.modelClass = modelClass;
        this.tableName = this.preEscape + ModelBuilder.getModelFabric(modelClass).getTableName() + this.postEscape;
        PrimaryKey pk = ModelBuilder.getModelFabric(modelClass).getPrimaryKey();
        if (pk == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "id";
        } else {
            stringArray = pk.value();
        }
        this.primaryKeyColumn = stringArray;
        this.attrs = ModelBuilder.getModelFabric(modelClass).getAttrMapping();
        if (this.attrs == null) {
            this.attrs = new HashMap<String, String>();
        }
        return this;
    }

    public FS<T> exclude(String ... columnNames) {
        if (columnNames == null) {
            throw new HbatisException("exclude columnNames is null");
        }
        ArrayList<String> columnExcludeList = new ArrayList<String>();
        for (int i = 0; i < columnNames.length; ++i) {
            columnExcludeList.add(columnNames[i]);
            columnExcludeList.add(this.mapColumn(columnNames[i]));
        }
        String[] tempColumnNames = new String[columnExcludeList.size()];
        columnExcludeList.toArray(tempColumnNames);
        Collections.addAll(this.excludedColumns, tempColumnNames);
        return this;
    }

    public FS<T> select(String columns) {
        if (null != this.selectColumns) {
            throw new HbatisException("Select method can only be called once.");
        }
        this.selectColumns = this.mapColumns(columns);
        return this;
    }

    public FS<T> distinct() {
        this.distinct = true;
        return this;
    }

    private String mapColumns(String columns) {
        String[] columnArray;
        this.beforeCheck();
        if (StrKit.isBlank(columns)) {
            return null;
        }
        StringBuilder mappedClumns = new StringBuilder();
        for (String column : columnArray = columns.split(",")) {
            mappedClumns.append(this.mapColumn(column.trim())).append(",");
        }
        mappedClumns.deleteCharAt(mappedClumns.length() - 1);
        return mappedClumns.toString();
    }

    private String mapColumn(String column) {
        String trueColumn = this.attrs.get(column);
        return this.preEscape + (trueColumn == null ? column : trueColumn) + this.postEscape;
    }

    public FS<T> where(String statement) {
        String trueStatement = this.mapColumn(statement);
        this.conditionSQL.append(" AND ").append(trueStatement);
        return this;
    }

    public FS<T> where(String statement, Object value) {
        String trueStatement = statement;
        trueStatement = !statement.contains("?") ? this.mapColumn(statement) + " = ?" : this.parseCondition(statement);
        this.conditionSQL.append(" AND ").append(trueStatement);
        this.paramValues.add(value);
        return this;
    }

    public FS<T> where(T model) {
        ModelFabric mf = ModelBuilder.getModelFabric(model.getClass());
        List<Field> declaredFields = mf.getFields();
        Map<String, String> attrs = mf.getAttrMapping();
        try {
            for (Field declaredField : declaredFields) {
                Object value = declaredField.get(model);
                if (null == value || declaredField.getType().equals(String.class) && StrKit.isBlank(value.toString())) continue;
                String columnName = attrs.get(declaredField.getName());
                this.where(columnName, value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            GLog.error("where model error:", e);
        }
        return this;
    }

    public FS<T> eq(Object value) {
        this.conditionSQL.append(" = ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> notNull() {
        this.conditionSQL.append(" IS NOT NULL");
        return this;
    }

    public FS<T> and(String statement, Object value) {
        return this.where(statement, value);
    }

    public FS<T> and(String statement) {
        return this.where((T)statement);
    }

    public FS<T> or(String statement, Object value) {
        String trueStatement = statement;
        trueStatement = !statement.contains("?") ? this.mapColumn(statement) + " = ?" : this.parseCondition(statement);
        this.conditionSQL.append(" OR (").append(trueStatement);
        this.conditionSQL.append(')');
        this.paramValues.add(value);
        return this;
    }

    private String parseCondition(String statement) {
        String tempStatement = statement.trim();
        int index = tempStatement.indexOf(" ");
        String column = tempStatement.substring(0, index);
        String conRemain = tempStatement.substring(index);
        String trueColumn = this.mapColumn(column);
        return trueColumn + " " + conRemain;
    }

    public FS<T> notEq(String columnName, Object value) {
        String trueColumnName = this.mapColumn(columnName);
        this.conditionSQL.append(" AND ").append(trueColumnName).append(" != ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> notEq(Object value) {
        this.conditionSQL.append(" != ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> notEmpty(String columnName) {
        String trueColumnName = this.mapColumn(columnName);
        this.conditionSQL.append(" AND ").append(trueColumnName).append(" != ''");
        return this;
    }

    public FS<T> notEmpty() {
        this.conditionSQL.append(" != ''");
        return this;
    }

    public FS<T> notNull(String columnName) {
        String trueColumnName = this.mapColumn(columnName);
        this.conditionSQL.append(" AND ").append(trueColumnName).append(" IS NOT NULL");
        return this;
    }

    public FS<T> like(String columnName, Object value) {
        String trueColumnName = this.mapColumn(columnName);
        this.conditionSQL.append(" AND ").append(trueColumnName).append(" LIKE ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> like(Object value) {
        this.conditionSQL.append(" LIKE ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> between(String columnName, Object a, Object b) {
        String trueColumnName = this.mapColumn(columnName);
        this.conditionSQL.append(" AND ").append(trueColumnName).append(" BETWEEN ? and ?");
        this.paramValues.add(a);
        this.paramValues.add(b);
        return this;
    }

    public FS<T> between(Object a, Object b) {
        this.conditionSQL.append(" BETWEEN ? and ?");
        this.paramValues.add(a);
        this.paramValues.add(b);
        return this;
    }

    public FS<T> gt(String columnName, Object value) {
        String trueColumnName = this.mapColumn(columnName);
        this.conditionSQL.append(" AND ").append(trueColumnName).append(" > ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> gt(Object value) {
        this.conditionSQL.append(" > ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> gte(Object value) {
        this.conditionSQL.append(" >= ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> lt(Object value) {
        this.conditionSQL.append(" < ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> lte(Object value) {
        this.conditionSQL.append(" <= ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> gte(String column, Object value) {
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(" AND ").append(trueColumnName).append(" >= ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> lt(String column, Object value) {
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(" AND ").append(trueColumnName).append(" < ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> lte(String column, Object value) {
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(" AND ").append(trueColumnName).append(" <= ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> in(String column, Object ... args) {
        if (null == args || args.length == 0) {
            GLog.error("column:{}, in params is empty.", column);
            return this;
        }
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(" AND ").append(trueColumnName).append(" IN (");
        this.setArguments(args);
        this.conditionSQL.append(")");
        return this;
    }

    public FS<T> in(Object ... args) {
        if (null == args || args.length == 0) {
            GLog.error("Column: {}, query params is empty.", new Object[0]);
            return this;
        }
        this.conditionSQL.append(" IN (");
        this.setArguments(args);
        this.conditionSQL.append(")");
        return this;
    }

    public <S> FS<T> in(List<S> list) {
        return this.in(list.toArray());
    }

    public <S> FS<T> in(String column, List<S> args) {
        return this.in(column, args.toArray());
    }

    public FS<T> order(String order) {
        String orderTemp;
        if (StrKit.isBlank(order)) {
            throw new HbatisException("order is empty");
        }
        if (this.orderBySQL.length() > 0) {
            this.orderBySQL.append(',');
        }
        String newOrder = orderTemp = order.trim();
        String column = null;
        String flag = null;
        int index = orderTemp.indexOf(" ");
        if (index > -1) {
            column = orderTemp.substring(0, index);
            flag = orderTemp.substring(index);
            newOrder = this.mapColumn(column) + " " + flag;
        }
        this.orderBySQL.append(' ').append(newOrder);
        return this;
    }

    public FS<T> order(String columnName, OrderBy orderBy) {
        if (this.orderBySQL.length() > 0) {
            this.orderBySQL.append(',');
        }
        String trueColumnName = this.mapColumn(columnName);
        this.orderBySQL.append(' ').append(trueColumnName).append(' ').append(orderBy.toString());
        return this;
    }

    public FS<T> set(String column, Object value) {
        String trueColumnName = this.mapColumn(column);
        this.updateColumns.put(trueColumnName, value);
        return this;
    }

    public FS<T> set(T model) {
        this.model = model;
        return this;
    }

    private void setArguments(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (i == args.length - 1) {
                this.conditionSQL.append("?");
            } else {
                this.conditionSQL.append("?, ");
            }
            this.paramValues.add(args[i]);
        }
    }

    private void beforeCheck() {
        if (null == this.modelClass) {
            throw new HbatisException("model calss is null");
        }
    }
}

