/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.db.common;

import cn.sylinx.hbatis.db.cache.CacheQuery;
import cn.sylinx.hbatis.db.common.BaseDbOper;
import cn.sylinx.hbatis.db.common.Callable;
import cn.sylinx.hbatis.db.common.DbOper;
import cn.sylinx.hbatis.db.common.DbPro;
import cn.sylinx.hbatis.db.common.DefaultCacheQuery;
import cn.sylinx.hbatis.db.common.HbatisService;
import cn.sylinx.hbatis.db.common.ITransaction;
import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.db.dialect.Dialect;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class DefaultHbatisService
implements HbatisService,
BaseDbOper {
    private final DbPro dbPro;
    private final CacheQuery cacheQuery;
    private final Map<String, HbatisService> map = new WeakHashMap<String, HbatisService>();

    public DefaultHbatisService() {
        this("_hbatis_default_jdbc_resource");
    }

    public DefaultHbatisService(String datasourceName) {
        this(DbPro.use(datasourceName));
    }

    private DefaultHbatisService(DbPro dbPro) {
        this.dbPro = dbPro;
        this.cacheQuery = this.createCacheQuery(new Object[0]);
        this.map.put(dbPro.getDataSourceName(), this);
    }

    @Override
    public String getDatasourceName() {
        return this.dbPro.getDataSourceName();
    }

    @Override
    public Dialect getDialect() {
        return this.dbPro.getDialect();
    }

    @Override
    public <T> T call(Callable<T> callable) {
        return this.dbPro.call(callable);
    }

    private CacheQuery createCacheQuery(Object ... params) {
        return new DefaultCacheQuery(this.dbPro);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HbatisService use(String jdbcResourceName) {
        HbatisService dbService = this.map.get(jdbcResourceName);
        if (dbService == null) {
            String string = jdbcResourceName.intern();
            synchronized (string) {
                this.createInstanceInner(jdbcResourceName);
            }
            dbService = this.map.get(jdbcResourceName);
        }
        return dbService;
    }

    private void createInstanceInner(String jdbcResourceName) {
        HbatisService dbService = this.map.get(jdbcResourceName);
        if (dbService == null) {
            dbService = new DefaultHbatisService(DbPro.use(jdbcResourceName));
            this.map.put(jdbcResourceName, dbService);
        }
    }

    @Override
    public CacheQuery withCache() {
        if (this.cacheQuery == null) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7f13\u5b58\u67e5\u8be2");
        }
        return this.cacheQuery;
    }

    protected CacheQuery getCacheQuery() {
        return this.cacheQuery;
    }

    @Override
    public boolean transaction(ITransaction transaction) {
        return this.dbPro.transaction(transaction);
    }

    @Override
    public <T> List<T> query(String sql, QueryMapper<T> mapper, Object ... params) {
        return this.dbPro.query(sql, mapper, params);
    }

    @Override
    public <T> T queryFirst(String sql, QueryMapper<T> mapper, Object ... params) {
        return this.dbPro.queryFirst(sql, mapper, params);
    }

    @Override
    public List<Object[]> query(String sql, Object ... params) {
        return this.dbPro.query(sql, params);
    }

    @Override
    public List<Map<String, Object>> queryMap(String sql, Object ... params) {
        return this.dbPro.queryMap(sql, params);
    }

    @Override
    public Object[] queryFirst(String sql, Object ... params) {
        return this.dbPro.queryFirst(sql, params);
    }

    @Override
    public Map<String, Object> queryFirstMap(String sql, Object ... params) {
        return this.dbPro.queryFirstMap(sql, params);
    }

    @Override
    public <PK> PK save(String insertSql, Object ... params) {
        return this.dbPro.save(insertSql, params);
    }

    @Override
    public int update(String updateSql, Object ... params) {
        return this.dbPro.update(updateSql, params);
    }

    @Override
    public <PK> PK updateWithReturnPk(String updateSql, Object ... params) {
        return this.dbPro.updateWithReturnPk(updateSql, params);
    }

    @Override
    public int[] batch(List<String> sql) {
        return this.dbPro.batch(sql);
    }

    @Override
    public int[] batch(String sql, Object[][] params) {
        return this.dbPro.batch(sql, params);
    }

    @Override
    public int[] batch(String sql, Object[][] params, int batchSize) {
        return this.dbPro.batch(sql, params, batchSize);
    }

    @Override
    public int[] batch(List<String> sqlList, int batchSize) {
        return this.dbPro.batch(sqlList, batchSize);
    }

    @Override
    public <T> int update(T t) {
        return this.dbPro.update(t);
    }

    @Override
    public <T> Object save(T t) {
        return this.dbPro.save(t);
    }

    @Override
    public <T> int delete(T t) {
        return this.dbPro.delete(t);
    }

    @Override
    public Record queryFirstRecord(String sql, Object ... params) {
        return this.dbPro.queryFirstRecord(sql, params);
    }

    @Override
    public List<Record> queryRecords(String sql, Object ... params) {
        return this.dbPro.queryRecords(sql, params);
    }

    @Override
    public boolean execute(String exeSql, Object ... params) {
        return this.dbPro.execute(exeSql, params);
    }

    @Override
    public boolean executeLargeUpdate(List<String> exeSqlList) {
        return this.dbPro.executeLargeUpdate(exeSqlList);
    }

    @Override
    public DbOper getDbOper() {
        return this;
    }

    @Override
    public boolean existTable(String schema, String table) {
        return this.dbPro.existTable(schema, table);
    }

    @Override
    public boolean existTableColumn(String schema, String table, String column) {
        return this.dbPro.existTableColumn(schema, table, column);
    }
}

