/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.tool;

import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.plugin.model.ModelFabric;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MysqlTableGenerateUtil {
    public static final String MYSQL_SINGLE_QUOTES = "`";
    public static final String MYSQL_DROP_TEMPLATE = "DROP TABLE IF EXISTS `%s`;";
    public static final String MYSQL_CREATE_TEMPLATE = "CREATE TABLE `%s` (";
    public static final String MYSQL_ROW_PK = " PRIMARY KEY (`id`) ";
    public static final String MYSQL_ENGINE = ") ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;";
    protected static final Map<String, String> MYSQL_JAVA_JDBC_MAP = new HashMap<String, String>();
    protected static final Map<String, Boolean> MYSQL_JDBC_COLLEN_MAP = new HashMap<String, Boolean>();
    private Class<? extends Object> clz;
    private List<Field> fields;
    private String tableName;
    private Map<String, String> attrMapping;

    public MysqlTableGenerateUtil(Class<? extends Object> clz) {
        this.clz = clz;
        if (clz == null) {
            throw new RuntimeException("clz is null or path is null");
        }
        ModelFabric modelFabric = ModelBuilder.getModelFabric(this.clz);
        this.fields = modelFabric.getFields();
        this.tableName = modelFabric.getTableName();
        this.attrMapping = modelFabric.getAttrMapping();
    }

    public String generateSql() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(MYSQL_CREATE_TEMPLATE, this.tableName)).append("\n");
        ArrayList<Field> sortField = new ArrayList<Field>();
        for (Field field : this.fields) {
            if (field.getName().equals("id")) {
                sortField.add(0, field);
                continue;
            }
            sortField.add(field);
        }
        for (Field field : sortField) {
            sb.append(this.generateSingleColumn(field)).append("\n");
        }
        sb.append(MYSQL_ROW_PK).append("\n");
        sb.append(MYSQL_ENGINE).append("\n");
        return sb.toString();
    }

    private String generateSingleColumn(Field field) {
        StringBuilder sb = new StringBuilder();
        String propertyName = field.getName();
        String javaType = this.getFieldType(field);
        String jdbcType = this.toJdbcType(javaType);
        String columName = this.attrMapping.get(propertyName);
        if (StrKit.isBlank(columName)) {
            columName = propertyName;
        }
        String column_template = "`%s` %s,";
        Boolean hasLen = MYSQL_JDBC_COLLEN_MAP.get(javaType);
        if (hasLen != null && hasLen.booleanValue()) {
            jdbcType = jdbcType + "(50)";
        }
        if ("id".equals(field.getName())) {
            jdbcType = "bigint(20) unsigned  NOT NULL AUTO_INCREMENT";
        }
        sb.append(String.format(column_template, columName, jdbcType));
        return sb.toString();
    }

    protected String toJdbcType(String javaType) {
        return MYSQL_JAVA_JDBC_MAP.get(javaType);
    }

    protected String getFieldType(Field field) {
        return field.getType().getName();
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    static {
        MYSQL_JAVA_JDBC_MAP.put("java.util.Date", "datetime");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.String", "varchar");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.Long", "bigint");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.Byte", "tinyint");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.Short", "smallint");
        MYSQL_JAVA_JDBC_MAP.put("java.math.BigInteger", "bigint(20) unsigned");
        MYSQL_JAVA_JDBC_MAP.put("java.math.BigDecimal", "decimal(10,2)");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.Integer", "int");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.Float", "float");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.Double", "double");
        MYSQL_JAVA_JDBC_MAP.put("java.lang.Boolean", "bit(1) DEFAULT b'0'");
        MYSQL_JDBC_COLLEN_MAP.put("java.lang.String", true);
    }
}

