/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.starter.common;

import cn.sylinx.hbatis.db.dialect.DbType;
import cn.sylinx.hbatis.db.dialect.sql.SqlBuilderFactory;
import cn.sylinx.hbatis.exception.HbatisException;
import cn.sylinx.hbatis.ext.mirage.plugin.SqlResourcePreloadPlugin;
import cn.sylinx.hbatis.ext.starter.common.RelaxedPropertyResolver;
import cn.sylinx.hbatis.ext.xmapper.plugin.XmapperPlugin;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.IPlugin;
import cn.sylinx.hbatis.plugin.PluginStarter;
import cn.sylinx.hbatis.plugin.datasource.DataSourcePlugin;
import cn.sylinx.hbatis.plugin.ehcache.EhcachePlugin;
import cn.sylinx.hbatis.plugin.model.ModelPreloadPlugin;
import cn.sylinx.hbatis.plugin.proxy.ProxyPlugin;
import cn.sylinx.hbatis.plugin.transaction.TransactionIsolationPlugin;
import com.alibaba.druid.pool.DruidDataSource;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;

class StarterBean {
    private String config = "/hbatis.properties";
    private Properties p;
    private DruidDataSource defaultDataSource;
    private Map<String, DruidDataSource> multiDataSources = new HashMap<String, DruidDataSource>();
    private List<IPlugin> pluginList = new ArrayList<IPlugin>();
    private PluginStarter pluginStarter;

    public StarterBean() {
        this(null);
    }

    public StarterBean(String config) {
        if (config != null && !"".equals(config)) {
            this.config = config;
        }
        this.init();
    }

    private void init() {
        this.p = new Properties();
        try {
            this.p.load(StarterBean.class.getResourceAsStream(this.config));
        }
        catch (IOException e) {
            throw new HbatisException(e);
        }
    }

    private void initHbatis() {
        this.initDefaultDataSource(this.p);
        this.initMultiDataSources(this.p);
        this.initDataSourcePlugin(this.p);
        this.initXmapperPlugin(this.p);
        this.initModelPreLoadPlugin(this.p);
        this.initEhcachePlugin(this.p);
        this.initSqlResourcePreloadPlugin(this.p);
        this.initTransactionPlugin(this.p);
        this.initProxyPlugin(this.p);
    }

    public void addPlugin(IPlugin plugin) {
        this.pluginList.add(plugin);
    }

    public void start() {
        String initKey = "hbatis.init";
        String initStr = this.p.getProperty(initKey, "false");
        boolean init = Boolean.valueOf(initStr);
        if (!init) {
            GLog.info("hbatis \u6ca1\u6709\u88ab\u521d\u59cb\u5316\uff0c\u8bf7\u786e\u8ba4hbatis.init=true\u3002", new Object[0]);
            return;
        }
        this.initHbatis();
        this.initPluginStarter();
    }

    private void initPluginStarter() {
        this.pluginStarter = new PluginStarter(this.pluginList);
        this.pluginStarter.start();
    }

    private void initDataSourcePlugin(Properties p) {
        DataSourcePlugin dsp = new DataSourcePlugin();
        dsp.setDataSource((DataSource)this.defaultDataSource);
        dsp.setDbType(this.defaultDataSource.getDbType());
        this.addPlugin(dsp);
        Set<Map.Entry<String, DruidDataSource>> kvSets = this.multiDataSources.entrySet();
        for (Map.Entry<String, DruidDataSource> kv : kvSets) {
            DataSourcePlugin ptmp = new DataSourcePlugin();
            ptmp.setDataSource((DataSource)kv.getValue());
            ptmp.setJdbcResourceName(kv.getKey());
            ptmp.setDbType(kv.getValue().getDbType());
            this.addPlugin(ptmp);
        }
    }

    private void initXmapperPlugin(Properties p) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver(p, "hbatis.plugin.xmapper.");
        String inited = propertyResolver.getProperty("inited");
        if (!"true".equalsIgnoreCase(inited)) {
            return;
        }
        GLog.debug("XmapperPlugin inited.", new Object[0]);
        String resourcePath = propertyResolver.getProperty("resourcePath");
        if (resourcePath == null || "".equals(resourcePath)) {
            resourcePath = "xmapper";
        }
        GLog.debug("XmapperPlugin resourcePath:{}", resourcePath);
        XmapperPlugin xmapperPlugin = new XmapperPlugin(resourcePath);
        this.addPlugin(xmapperPlugin);
    }

    private void initModelPreLoadPlugin(Properties p) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver(p, "hbatis.plugin.modelpreload.");
        String inited = propertyResolver.getProperty("inited");
        if (!"true".equalsIgnoreCase(inited)) {
            return;
        }
        GLog.debug("ModelPreloadPlugin inited.", new Object[0]);
        String scanPackageList = propertyResolver.getProperty("scanPackageList");
        if (scanPackageList == null || "".equals(scanPackageList)) {
            return;
        }
        GLog.debug("ModelPreloadPlugin scanPackageList:{}", scanPackageList);
        ModelPreloadPlugin mp = new ModelPreloadPlugin();
        String[] pkgArray = scanPackageList.split(",");
        mp.setScanPackageList(Arrays.asList(pkgArray));
        this.addPlugin(mp);
    }

    private void initSqlResourcePreloadPlugin(Properties p) {
        String path = p.getProperty("hbatis.plugin.mirage.sqlpath");
        if (StrKit.isBlank(path)) {
            return;
        }
        String[] pathArray = path.split(",");
        List<String> pathList = Arrays.asList(pathArray);
        SqlResourcePreloadPlugin plugin = new SqlResourcePreloadPlugin(pathList);
        this.addPlugin(plugin);
    }

    private void initTransactionPlugin(Properties p) {
        String level = p.getProperty("hbatis.plugin.transaction.level");
        if (StrKit.isBlank(level)) {
            return;
        }
        int levelInt = Integer.parseInt(level);
        TransactionIsolationPlugin plugin = new TransactionIsolationPlugin(levelInt);
        this.addPlugin(plugin);
    }

    private void initProxyPlugin(Properties p) {
        String[] clzArray;
        String clzList = p.getProperty("hbatis.plugin.proxy.class");
        if (StrKit.isBlank(clzList)) {
            return;
        }
        ProxyPlugin plugin = new ProxyPlugin();
        for (String clz : clzArray = clzList.split(",")) {
            if (!StrKit.isNotBlank(clz)) continue;
            IPlugin item = null;
            try {
                item = (IPlugin)Class.forName(clz.trim()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                GLog.error("\u521d\u59cb\u5316\u63d2\u4ef6\u5931\u8d25, clz: " + clz, e);
            }
            if (item == null) continue;
            plugin.addPlugin(item);
        }
        this.addPlugin(plugin);
    }

    private void initEhcachePlugin(Properties p) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver(p, "hbatis.plugin.ehcache.");
        String inited = propertyResolver.getProperty("inited");
        if (!"true".equalsIgnoreCase(inited)) {
            return;
        }
        GLog.debug("EhcachePlugin inited.", new Object[0]);
        this.addPlugin(new EhcachePlugin());
    }

    private void initDefaultDataSource(Properties p) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver(p, "hbatis.datasource.default.");
        HashMap<String, Object> dsMap = new HashMap<String, Object>();
        dsMap.put("url", propertyResolver.getProperty("url"));
        dsMap.put("driver", propertyResolver.getProperty("driver"));
        dsMap.put("username", propertyResolver.getProperty("username"));
        dsMap.put("password", propertyResolver.getProperty("password"));
        dsMap.put("initalSize", propertyResolver.getProperty("initalSize", "2"));
        dsMap.put("minIdle", propertyResolver.getProperty("minIdle", "1"));
        dsMap.put("maxActive", propertyResolver.getProperty("maxActive", "20"));
        dsMap.put("dbtype", propertyResolver.getProperty("dbtype"));
        dsMap.put("filters", propertyResolver.getProperty("filters"));
        this.defaultDataSource = this.buildDataSource(dsMap);
    }

    private void initMultiDataSources(Properties p) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver(p, "hbatis.datasource.multi.");
        String dsPrefixs = propertyResolver.getProperty("names");
        if (dsPrefixs == null || "".equals(dsPrefixs)) {
            return;
        }
        for (String dsPrefix : dsPrefixs.split(",")) {
            Map<String, Object> dsMap = propertyResolver.getSubProperties(dsPrefix + ".");
            DruidDataSource ds = this.buildDataSource(dsMap);
            this.multiDataSources.put(dsPrefix, ds);
        }
    }

    private DruidDataSource buildDataSource(Map<String, Object> dsMap) {
        Object dcnObject = dsMap.get("driver");
        String driverClassName = null;
        if (dcnObject != null && !"".equals(dcnObject.toString().trim())) {
            driverClassName = dcnObject.toString();
        }
        Object filtersObject = dsMap.get("filters");
        String filters = null;
        if (filtersObject != null && !"".equals(filtersObject.toString().trim())) {
            filters = filtersObject.toString();
        }
        String dbType = dsMap.get("dbtype").toString();
        DruidDataSource cds = new DruidDataSource();
        cds.setUrl(dsMap.get("url").toString());
        cds.setDriverClassName(driverClassName);
        cds.setUsername(dsMap.get("username").toString());
        cds.setPassword(dsMap.get("password").toString());
        cds.setInitialSize(Integer.valueOf(dsMap.get("initalSize").toString()).intValue());
        cds.setMinIdle(Integer.valueOf(dsMap.get("minIdle").toString()).intValue());
        cds.setMaxActive(Integer.valueOf(dsMap.get("maxActive").toString()).intValue());
        cds.setDbType(dbType);
        cds.setTestWhileIdle(true);
        cds.setValidationQuery(this.getValidateQuery(dbType));
        try {
            cds.setFilters(filters);
        }
        catch (SQLException e) {
            GLog.error("set filters error", e);
        }
        return cds;
    }

    public String getValidateQuery(String dbtype) {
        DbType dt = DbType.getDbType(dbtype);
        return SqlBuilderFactory.get().getSqlBuilder(dt).buildValidateQuery();
    }
}

