package cn.sylinx.hbatis.plugin.model;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import cn.sylinx.hbatis.db.mapper.anno.AttributeColumnMapping;
import cn.sylinx.hbatis.db.mapper.anno.PrimaryKey;
import cn.sylinx.hbatis.db.mapper.anno.Table;

/**
 * model结构
 * 
 * @author han
 *
 */
public class ModelFabric {

	private Table table;

	private PrimaryKey primaryKey;

	private AttributeColumnMapping mapping;

	private Map<String, Field> fieldMap;

	private List<Field> fields;

	private Class<?> clz;

	private Map<String, String> attrMapping;

	public Map<String, String> getAttrMapping() {
		return attrMapping;
	}

	public Map<String, String> getJdbcMapping() {

		Map<String, String> jdbcMapping = new HashMap<String, String>();
		if (attrMapping == null) {
			return jdbcMapping;
		}

		Set<Entry<String, String>> entrys = attrMapping.entrySet();
		for (Entry<String, String> entry : entrys) {
			jdbcMapping.put(entry.getValue(), entry.getKey());
		}
		return jdbcMapping;
	}

	public void setAttrMapping(Map<String, String> attrMapping) {
		this.attrMapping = attrMapping;
	}

	public List<Field> getFields() {
		return fields;
	}

	public void setFields(List<Field> fields) {
		this.fields = fields;
	}

	public Table getTable() {
		return table;
	}

	public String getTableName() {
		if (table == null) {
			return null;
		}

		return table.value();
	}

	public void setTable(Table table) {
		this.table = table;
	}

	public PrimaryKey getPrimaryKey() {
		return primaryKey;
	}

	public void setPrimaryKey(PrimaryKey primaryKey) {
		this.primaryKey = primaryKey;
	}

	public AttributeColumnMapping getMapping() {
		return mapping;
	}

	public void setMapping(AttributeColumnMapping mapping) {
		this.mapping = mapping;
	}

	public Map<String, Field> getFieldMap() {
		return fieldMap;
	}

	public void setFieldMap(Map<String, Field> fieldMap) {
		this.fieldMap = fieldMap;
	}

	public Class<?> getClz() {
		return clz;
	}

	public void setClz(Class<?> clz) {
		this.clz = clz;
	}

	public void clear() {

		table = null;
		primaryKey = null;
		mapping = null;

		if (fieldMap != null) {
			fieldMap.clear();
			fieldMap = null;
		}

		if (fields != null) {
			fields.clear();
			fields = null;
		}

		if (attrMapping != null) {
			attrMapping.clear();
			attrMapping = null;
		}

		clz = null;
	}

	public boolean isMappingEmpty() {

		if (attrMapping == null || attrMapping.isEmpty()) {
			return true;
		}

		return false;
	}

}
