package cn.sylinx.hbatis.ext.tool;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.plugin.model.ModelFabric;

public class MysqlTableGenerateUtil {

	public static final String MYSQL_SINGLE_QUOTES = "`";

	public static final String MYSQL_DROP_TEMPLATE = "DROP TABLE IF EXISTS `%s`;";

	public static final String MYSQL_CREATE_TEMPLATE = "CREATE TABLE `%s` (";

	public static final String MYSQL_ROW_PK = " PRIMARY KEY (`id`) ";

	public static final String MYSQL_ENGINE = ") ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;";

	protected final static Map<String, String> MYSQL_JAVA_JDBC_MAP = new HashMap<String, String>();

	protected final static Map<String, Boolean> MYSQL_JDBC_COLLEN_MAP = new HashMap<String, Boolean>();

	static {

		MYSQL_JAVA_JDBC_MAP.put("java.util.Date", "datetime");
		MYSQL_JAVA_JDBC_MAP.put("java.lang.String", "varchar");
		MYSQL_JAVA_JDBC_MAP.put("java.lang.Long", "bigint");
		MYSQL_JAVA_JDBC_MAP.put("java.lang.Byte", "tinyint");
		MYSQL_JAVA_JDBC_MAP.put("java.lang.Short", "smallint");
		MYSQL_JAVA_JDBC_MAP.put("java.math.BigInteger", "bigint(20) unsigned");
		MYSQL_JAVA_JDBC_MAP.put("java.math.BigDecimal", "decimal(10,2)");
		MYSQL_JAVA_JDBC_MAP.put("java.lang.Integer", "int");
		MYSQL_JAVA_JDBC_MAP.put("java.lang.Float", "float");
		MYSQL_JAVA_JDBC_MAP.put("java.lang.Double", "double");
		MYSQL_JAVA_JDBC_MAP.put("java.lang.Boolean", "bit(1) DEFAULT b'0'");
	}

	static {
		MYSQL_JDBC_COLLEN_MAP.put("java.lang.String", true);
	}

	private Class<? extends Object> clz;

	private List<Field> fields;

	private String tableName;

	private Map<String, String> attrMapping;

	public MysqlTableGenerateUtil(Class<? extends Object> clz) {

		this.clz = clz;

		if (clz == null) {
			throw new RuntimeException("clz is null or path is null");
		}

		ModelFabric modelFabric = ModelBuilder.getModelFabric(this.clz);
		fields = modelFabric.getFields();
		tableName = modelFabric.getTableName();
		attrMapping = modelFabric.getAttrMapping();

	}

	/**
	 * 生成表的SQL
	 * 
	 * @return
	 */
	public String generateSql() {

		StringBuilder sb = new StringBuilder();
		sb.append(String.format(MYSQL_CREATE_TEMPLATE, tableName)).append("\n");
		List<Field> sortField = new ArrayList<Field>();
		for (Field field : fields) {
			if (field.getName().equals("id")) {
				sortField.add(0, field);
			} else {
				sortField.add(field);
			}
		}
		for (Field field : sortField) {
			sb.append(generateSingleColumn(field)).append("\n");
		}
		sb.append(MYSQL_ROW_PK).append("\n");
		sb.append(MYSQL_ENGINE).append("\n");

		return sb.toString();
	}

	private String generateSingleColumn(Field field) {

		StringBuilder sb = new StringBuilder();

		String propertyName = field.getName();
		String javaType = getFieldType(field);

		String jdbcType = toJdbcType(javaType);
		String columName = attrMapping.get(propertyName);
		if (StrKit.isBlank(columName)) {
			columName = propertyName;
		}

		String column_template = MYSQL_SINGLE_QUOTES + "%s" + MYSQL_SINGLE_QUOTES + " %s,";

		Boolean hasLen = MYSQL_JDBC_COLLEN_MAP.get(javaType);
		if (hasLen != null && hasLen.booleanValue()) {
			jdbcType = jdbcType + "(50)";
		}

		if ("id".equals(field.getName())) {
			// id主键
			jdbcType = "bigint(20) unsigned  NOT NULL AUTO_INCREMENT";
		}

		sb.append(String.format(column_template, columName, jdbcType));

		return sb.toString();
	}

	/**
	 * 获取javaType对应的 jdbcType
	 * 
	 * @param javaType
	 * @return
	 */
	protected String toJdbcType(String javaType) {

		return MYSQL_JAVA_JDBC_MAP.get(javaType);
	}

	/**
	 * 获取字段类型
	 * 
	 * @param field
	 * @return
	 */
	protected String getFieldType(Field field) {

		return field.getType().getName();
	}

	public List<Field> getFields() {
		return fields;
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}
}