package cn.sylinx.hbatis.ext.starter.util;

import cn.sylinx.hbatis.ext.common.Hbatis;
import cn.sylinx.hbatis.ext.common.repository.CommonDaoService;
import cn.sylinx.hbatis.ext.mirage.Mirage;
import cn.sylinx.hbatis.ext.xmapper.Xmapper;
import cn.sylinx.hbatis.kit.StrKit;

public abstract class DAO {

	public static CommonDaoService hbatis() {
		return Hbatis.getDaoService();
	}

	public static CommonDaoService hbatis(String dsName) {

		if (StrKit.isBlank(dsName)) {
			return hbatis();
		}
		return Hbatis.getDaoService(dsName);
	}

	public static cn.sylinx.hbatis.ext.mirage.repository.DaoService mirage() {
		return Mirage.getDaoService();
	}

	public static cn.sylinx.hbatis.ext.mirage.repository.DaoService mirage(String dsName) {
		if (StrKit.isBlank(dsName)) {
			return mirage();
		}
		return Mirage.getDaoService(dsName);
	}

	public static cn.sylinx.hbatis.ext.xmapper.repository.DaoService xmapper() {
		return Xmapper.getDaoService();
	}

	public static cn.sylinx.hbatis.ext.xmapper.repository.DaoService xmapper(String dsName) {
		if (StrKit.isBlank(dsName)) {
			return xmapper();
		}
		return Xmapper.getDaoService(dsName);
	}

}
