package cn.sylinx.hbatis.ext.parse;

import java.util.Map;

import cn.sylinx.hbatis.ext.res.ClasspathSqlResource;
import cn.sylinx.hbatis.ext.res.ClasspathSqlResourceManager;
import cn.sylinx.hbatis.ext.res.StatementHandler;
import cn.sylinx.hbatis.kit.Tuple;
import cn.sylinx.hbatis.log.GLog;

public abstract class SqlParser {

	public static Tuple parseSql(ClasspathSqlResource sqlResource, Map<String, Object> params) {
		String statement = ClasspathSqlResourceManager.getStatement(sqlResource.getSqlpath());
		return parseSql(statement, params, sqlResource.getStatementHandler());
	}

	public static Tuple parseSql(String statement, Map<String, Object> params, StatementHandler sqlHandler) {
		SqlTokenHandler handler = new SqlTokenHandler(params);
		GenericTokenParser gt = new GenericTokenParser(handler);
		Tuple tp = gt.parse(statement);

		if (sqlHandler != null) {
			String statementReplace = sqlHandler.handle(tp.getObject(0, String.class));
			GLog.debug("changed sql: " + statementReplace);
			return Tuple.apply(statementReplace, tp.get(1));
		}

		return tp;
	}
}
