package cn.sylinx.hbatis.ext.common.repository;

import java.math.BigInteger;
import java.util.List;

import cn.sylinx.hbatis.db.common.ITransaction;
import cn.sylinx.hbatis.db.common.Page;
import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.db.dialect.Dialect;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import cn.sylinx.hbatis.ext.model.GenericModel;
import cn.sylinx.hbatis.kit.Tuple;

public interface CommonDaoService {

	/**
	 * 获取数据源名称
	 * 
	 * @return
	 */
	public String getDatasourceName();

	/**
	 * 获取数据库类型
	 * 
	 * @return
	 */
	public Dialect getDialect();

	/**
	 * 查询
	 * 
	 * @param sql
	 * @param mapper
	 * @param params
	 * @return
	 */
	public <T> List<T> query(final String sql, final QueryMapper<T> mapper, final Object... params);

	/**
	 * 查询记录
	 * 
	 * 
	 * @param nativeSql
	 * @param params
	 * @return
	 */
	List<Record> queryRecordsWithSql(String nativeSql, Object... params);

	/**
	 * 查询记录
	 * 
	 * 
	 * @param nativeSql
	 * @param params
	 * @return
	 */
	Record queryRecordWithSql(String nativeSql, Object... params);

	/**
	 * 更新
	 * 
	 * 
	 * @param nativeSql
	 * @param params
	 * @return
	 */
	int updateWithSql(String nativeSql, Object... params);

	/**
	 * 事务处理
	 * 
	 * @param transactions
	 * @return
	 */
	public boolean transaction(ITransaction transactions);

	/**
	 * 执行脚本,包括ddl
	 * 
	 * @param resource
	 * @return
	 */
	boolean executeLargeUpdate(final List<String> nativeExeSqlList);

	boolean existTable(final String schema, final String table);

	<T> int update(T t);

	<T> int updateObject(T t);

	<T> int delete(T t);

	<T> int delete(BigInteger id, Class<T> clz);

	<T> int delete(List<Tuple> kvList, Class<T> clz);

	<T> int deleteObject(Object pk, Class<T> clz);

	<T> int deleteObject(List<Tuple> kvList, Class<T> clz);

	<T> T get(BigInteger id, Class<T> clz);
	
	<T> T get(BigInteger id, Class<T> clz, String[] fields);
	
	<T> T get(BigInteger id, Class<T> clz, String[] fields, boolean cached);
	
	<T> T get(BigInteger id, Class<T> clz, boolean cached);

	/**
	 * T对象中必须有id字段
	 */
	<T> T getObject(Object pk, Class<T> clz);

	<T> T getByNumber(String number, Class<T> clz);

	<T> T getByField(Tuple kv, Class<T> clz);

	<T> List<T> getByField(List<Tuple> kvList, Class<T> clz);

	<T> T getObjectByNumber(String number, Class<T> clz);

	<T> List<T> getObjectByField(List<Tuple> kvList, Class<T> clz);
	
	<T> List<T> getObjectByField(List<Tuple> kvList, Class<T> clz, String[] fields);

	/**
	 * 是否使用缓存查询
	 * 
	 * @param kvList
	 * @param clz
	 * @param cached
	 * @return
	 */
	<T> List<T> getObjectByField(List<Tuple> kvList, Class<T> clz, boolean cached);
	
	<T> List<T> getObjectByField(List<Tuple> kvList, Class<T> clz, String[] fields, boolean cached);

	<T> T getObjectByField(Tuple kv, Class<T> clz);

	<T extends GenericModel<Object>> T add(T t);

	<T> boolean justAdd(T t);

	Object insert(String insertSql, Object... params);

	/**
	 * return pk
	 * 
	 * @param t
	 * @return
	 */
	<T> Object addObject(T t);

	<T> boolean justAddObject(T t);

	<T> List<T> query(Class<T> clz);

	<T> List<T> querySqlList(String sql, Class<T> clz, Object... params);

	<T> Page<T> queryPage(Class<T> clz, int pageNumber, int pageSize);

	<T> Page<T> queryPage(Class<T> clz, int pageNumber);

	<T> Page<T> queryPage(String sql, int pageNumber, int pageSize, Class<T> clz, Object... params);

	<T> Page<Record> queryPageRecords(Class<T> clz, int pageNumber, int pageSize);

	<T> Page<Record> queryPageRecords(Class<T> clz, int pageNumber);

	<T> Page<Record> queryPageRecords(String sql, int pageNumber, int pageSize, Object... params);

	<T> List<T> queryWithCache(Class<T> clz);

	<T> List<T> querySqlListWithCache(String nativeSql, Class<T> clz, Object... params);

	List<Record> querySqlRecordsWithCache(String sql, Object... params);

}
