package cn.sylinx.hbatis.ds;

import java.sql.Connection;
import java.sql.SQLException;

import cn.sylinx.hbatis.exception.BlockException;

/**
 * JDBC执行块
 * 
 * @author han
 *
 * @param <O>
 *            O
 */
public abstract class JdbcBlock<O> implements ResourceBlock<Connection, O> {

	@Override
	public O apply(Connection resource) throws BlockException {

		try {
			return applyBlock(resource);
		} catch (Throwable e) {
			throw new BlockException(e);
		}
	}

	/**
	 * 执行快
	 * 
	 * @param resource
	 *            Connection对象
	 * @return O
	 * @throws Exception
	 *             Exception
	 */
	public abstract O applyBlock(Connection resource) throws SQLException;

}
