package cn.sylinx.hbatis.db.mapper;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import cn.sylinx.hbatis.exception.MappingFileNotFoundException;
import cn.sylinx.hbatis.io.Resources;
import cn.sylinx.hbatis.log.GLog;

public class MappingFileManager {

	private static MappingFileManager instance = new MappingFileManager();

	private Map<String, Properties> mapStore = new HashMap<String, Properties>();

	private MappingFileManager() {

	}

	public static MappingFileManager get() {
		return instance;
	}

	public Properties getMappingFile(String resource) {

		Properties p = mapStore.get(resource);
		if (p != null) {
			return p;
		}

		GLog.debug("加载映射文件:{}", resource);
		try {
			p = Resources.getResourceAsProperties(resource);
			mapStore.put(resource, p);
		} catch (IOException e) {
			throw new MappingFileNotFoundException("can not load resource :" + resource, e);
		}

		return p;
	}
}
