package cn.sylinx.hbatis.db.dialect.sql;

import java.util.List;

import cn.sylinx.hbatis.kit.Tuple;

public interface SqlBuilder {

	/**
	 * 获取分页sql
	 * 
	 * @param preSql
	 * @param pageNumber
	 * @param pageSize
	 * @return Tuple 0：获取总行数sql，1：查询数据sql，3：分页参数
	 */
	Tuple buildPaginatorSql(String preSql, int pageNumber, int pageSize);

	/**
	 * 构建删除sql
	 * 
	 * @param t
	 * @return
	 */
	public <T> Tuple buildDeleteSQL(T t);

	/**
	 * 构建插入sql
	 * 
	 * @param t
	 * @return
	 */
	public <T> Tuple buildInsertSQL(T t);

	/**
	 * 构建更新sql
	 * 
	 * @param t
	 * @return
	 */
	public <T> Tuple buildUpdateSQL(T t);

	/**
	 * 构建根据字段删除sql
	 * 
	 * @param kvList
	 * @param clz
	 * @return
	 */
	public Tuple buildDeleteByFieldSQL(List<Tuple> kvList, Class<?> clz);

	/**
	 * 构建根据字段查询sql
	 * 
	 * @param kvList
	 * @param clz
	 * @return
	 */
	public Tuple buildQueryByFieldSQL(List<Tuple> kvList, Class<?> clz);
	
	/**
	 * 构建根据字段查询sql
	 * @param kvList
	 * @param clz
	 * @param fields
	 * @return
	 */
	public Tuple buildQueryByFieldSQL(List<Tuple> kvList, Class<?> clz, String[] fields);

	/**
	 * 构建简单查询 select * from table
	 * 
	 * @param clz
	 * @return
	 */
	public String buildSimpleQuery(Class<?> clz);
	
	/**
	 * 构建简单查询  select field_name from table
	 * @param clz
	 * @param fields
	 * @return
	 */
	public String buildSimpleQuery(Class<?> clz, String[] fields);
	
	/**
	 * 合法检测语句
	 * @return
	 */
	public String buildValidateQuery();
}
