package cn.sylinx.hbatis.db.dialect;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import cn.sylinx.hbatis.db.dialect.sql.SqlBuilder;

public interface Dialect {

	void setParameters(PreparedStatement pst, Object... params) throws SQLException;

	void setParameters(PreparedStatement pst, List<Object> params) throws SQLException;

	<T> T getResult(ResultSet rs, String columnName, Class<T> clz) throws SQLException;

	<T> T getResult(ResultSet rs, int columnIndex, Class<T> clz) throws SQLException;

	<T> T getResult(CallableStatement cs, int columnIndex, Class<T> clz) throws SQLException;

	/**
	 * 数据库类型
	 * 
	 * @return
	 */
	DbType getDbType();

	/**
	 * 获取sql builder
	 * 
	 * @return
	 */
	SqlBuilder getSqlBuilder();
}
