package cn.sylinx.hbatis.db.dialect;

public enum DbType {

	MYSQL("mysql"),

	ORACLE("oracle"),

	SQLSERVER("sqlserver"),

	DB2("db2"),

	DERBY("derby"),
	
	POSTGRESQL("postgresql"),
	
	H2("h2");

	private String value;

	private DbType(String value) {
		this.value = value;
	}

	public String getValue() {
		return value;
	}

	public static DbType getDbType(String dbTypeStr) {

		DbType[] dbts = DbType.values();
		for (DbType item : dbts) {
			if (item.getValue().equals(dbTypeStr)) {
				return item;
			}
		}

		throw new IllegalArgumentException("不支持的数据库类型：" + dbTypeStr);

	}

}
