package cn.sylinx.hbatis.db.common;

import cn.sylinx.hbatis.db.cache.CacheQuery;
import cn.sylinx.hbatis.db.dialect.Dialect;

/**
 * 数据库操作接口
 * 
 * @author han
 *
 */
public interface HbatisService extends DbMapper, DbOper {

	/**
	 * 使用特定的数据库操作对象
	 * 
	 * @param dataSourceName
	 *            数据源名称
	 * @return HbatisService
	 */
	public HbatisService use(String dataSourceName);

	/**
	 * 数据源
	 * 
	 * @return
	 */
	public String getDatasourceName();

	/**
	 * DB类型
	 * 
	 * @return
	 */
	public Dialect getDialect();

	/**
	 * 使用缓存查询
	 * 
	 * @return
	 */
	CacheQuery withCache();

}
