
package cn.sylinx.hbatis.db.common;

import java.util.List;

/**
 * native sql 操作支持
 *
 * @author hanqz
 */
public interface DbOper extends DbQuery {

	/**
	 * 是否存在表
	 * 
	 * @param schema
	 * @param table
	 * @return
	 */
	public boolean existTable(final String schema, final String table);

	/**
	 * 事务处理
	 * 
	 * @param transaction
	 *            事务执行接口
	 * @return
	 */
	public boolean transaction(ITransaction transaction);

	/**
	 * 保存
	 * 
	 * @param insertSql
	 *            插入sql
	 * @param params
	 *            参数列表
	 * @return 主键
	 */
	public Object save(final String insertSql, final Object... params);

	/**
	 * 更新
	 * 
	 * @param updateSql
	 *            更新sql
	 * @param params
	 *            参数列表
	 * @return 更新行数
	 */
	public int update(final String updateSql, final Object... params);

	/**
	 * 更新，带返回主键
	 * 
	 * @param updateSql
	 * @param params
	 * @return
	 */
	public Object updateWithReturnPk(final String updateSql, final Object... params);

	/**
	 * 执行sql
	 * 
	 * @param exeSql
	 * @param params
	 * @return
	 */
	public boolean execute(final String exeSql, final Object... params);

	/**
	 *  执行超大sql，包括ddl
	 * @param exeSql
	 * @return
	 */
	public boolean executeLargeUpdate(final List<String> exeSqlList);

	/**
	 * 批量执行语句
	 * 
	 * @param sql
	 *            sql语句（更新、插入、删除）
	 * @return 影响行数
	 */
	public int[] batch(final List<String> sql);

	/**
	 * 批量执行语句
	 * 
	 * @param sql
	 *            sql语句（更新、插入、删除）
	 * @param params
	 *            参数
	 * @return 影响行数
	 */
	public int[] batch(final String sql, final Object[][] params);

	/**
	 * 批量执行语句
	 * 
	 * @param sql
	 *            sql语句（更新、插入、删除）
	 * @param params
	 *            参数
	 * @param batchSize
	 *            批量提交量
	 * @return 影响行数
	 */
	public int[] batch(final String sql, final Object[][] params, final int batchSize);

	/**
	 * 批量执行语句
	 * 
	 * @param sqlList
	 *            sql列表
	 * @param batchSize
	 *            批量提交量
	 * @return 影响行数
	 */
	public int[] batch(final List<String> sqlList, final int batchSize);
}
