package cn.sylinx.hbatis.db.common;

import cn.sylinx.hbatis.db.mapper.DeleteMapper;
import cn.sylinx.hbatis.db.mapper.InsertMapper;
import cn.sylinx.hbatis.db.mapper.UpdateMapper;

/**
 * 简单的映射操作
 * 
 * @author han
 *
 */
public interface DbMapper extends MapperQuery {

	/**
	 * 更新
	 * 
	 * @param t
	 *            更新
	 * @param mapper
	 *            更新Mapper
	 * @return 更新记录数
	 */
	public <T> int update(T t, UpdateMapper<T> mapper);

	/**
	 * 更新
	 * 
	 * @param t
	 *            更新
	 * @return 更新记录数
	 */
	public <T> int update(T t);

	/**
	 * 保存
	 * 
	 * @param t
	 *            T对象
	 * @param mapper
	 *            插入Mapper
	 * @return 主键
	 */
	public <T> Object save(T t, InsertMapper<T> mapper);

	/**
	 * 保存
	 * 
	 * @param t
	 *            T对象
	 * @return 主键
	 */
	public <T> Object save(T t);

	/**
	 * 删除
	 * 
	 * @param t
	 *            T对象
	 * @param mapper
	 *            删除Mapper
	 * @return 删除数量
	 */
	public <T> int delete(T t, DeleteMapper<T> mapper);

	/**
	 * 删除
	 * 
	 * @param t
	 *            T对象
	 * @return 删除数量
	 */
	public <T> int delete(T t);

}
