/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.plugin.model;

import cn.sylinx.hbatis.io.ClasspathResourceScanner;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.IPlugin;
import cn.sylinx.hbatis.plugin.model.ModelCacheManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ModelPreloadPlugin
implements IPlugin {
    private List<String> scanPackageList;
    private Set<String> clzSets;

    public List<String> getScanPackageList() {
        return this.scanPackageList;
    }

    public void setScanPackageList(List<String> scanPackageList) {
        this.scanPackageList = scanPackageList;
    }

    public Set<String> getClzSets() {
        return this.clzSets;
    }

    public void setClzSets(Set<String> clzSets) {
        this.clzSets = clzSets;
    }

    @Override
    public boolean start(Object ... objects) {
        if (this.clzSets == null) {
            this.clzSets = new HashSet<String>();
        }
        if (this.scanPackageList != null && !this.scanPackageList.isEmpty()) {
            for (String scanOnePackage : this.scanPackageList) {
                this.scanOnePackage(scanOnePackage);
            }
        }
        ModelCacheManager.get().init(this.clzSets);
        return true;
    }

    private void scanOnePackage(String scanPackage) {
        GLog.debug("\u626b\u63cf\u5305[{}]...", scanPackage);
        ClasspathResourceScanner cp = new ClasspathResourceScanner(scanPackage, ".class", true);
        List<String> rList = null;
        try {
            rList = cp.getResourceNameList();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rList == null) {
            rList = new ArrayList<String>();
        }
        for (String rs : rList) {
            String pt1 = rs.replaceAll("/", "\\.");
            int index = pt1.lastIndexOf(".class");
            pt1 = pt1.substring(0, index);
            this.clzSets.add(pt1);
        }
    }

    @Override
    public boolean stop() {
        return true;
    }
}

