/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.common.repository;

import cn.sylinx.hbatis.db.common.ITransaction;
import cn.sylinx.hbatis.db.common.Page;
import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.db.dialect.Dialect;
import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import cn.sylinx.hbatis.ext.common.repository.CommonDaoService;
import cn.sylinx.hbatis.ext.common.repository.CommonRepository;
import cn.sylinx.hbatis.ext.common.spi.HbatisServiceManager;
import cn.sylinx.hbatis.ext.model.BaseModel;
import cn.sylinx.hbatis.ext.model.GenericModel;
import cn.sylinx.hbatis.ext.res.StatementHandler;
import cn.sylinx.hbatis.kit.Tuple;
import cn.sylinx.hbatis.log.GLog;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class CommonDaoServiceImpl
implements CommonDaoService {
    private CommonRepository commonRepository;

    public CommonDaoServiceImpl() {
    }

    public CommonDaoServiceImpl(CommonRepository commonRepository) {
        this.commonRepository = commonRepository;
    }

    @Override
    public String getDatasourceName() {
        return this.commonRepository.getDatabase();
    }

    @Override
    public Dialect getDialect() {
        return this.commonRepository.getDialect();
    }

    @Override
    public boolean transaction(ITransaction transactions) {
        return this.commonRepository.transaction(transactions);
    }

    @Override
    public <T> List<T> query(String sql, QueryMapper<T> mapper, Object ... params) {
        return HbatisServiceManager.getHbatisService().use(this.commonRepository.getDatabase()).query(sql, mapper, params);
    }

    protected StatementHandler getStatementHandler() {
        return null;
    }

    protected String handlerStatement(String nativeSql) {
        StatementHandler hander = this.getStatementHandler();
        if (hander == null) {
            return nativeSql;
        }
        String changeSql = hander.handle(nativeSql);
        GLog.debug("nativeSql : {} ", nativeSql);
        GLog.debug("changeSql : {} ", changeSql);
        return changeSql;
    }

    @Override
    public List<Record> queryRecordsWithSql(String nativeSql, Object ... params) {
        String changeSql = this.handlerStatement(nativeSql);
        GLog.debug("params : {} ", params);
        return this.commonRepository.queryRecords(changeSql, params);
    }

    @Override
    public Record queryRecordWithSql(String nativeSql, Object ... params) {
        String changeSql = this.handlerStatement(nativeSql);
        GLog.debug("params : {} ", params);
        return this.commonRepository.queryRecord(changeSql, params);
    }

    @Override
    public int updateWithSql(String nativeSql, Object ... params) {
        String changeSql = this.handlerStatement(nativeSql);
        GLog.debug("params : {} ", params);
        return this.commonRepository.update(changeSql, params);
    }

    @Override
    public boolean executeLargeUpdate(List<String> nativeExeSqlList) {
        return this.commonRepository.executeLargeUpdate(nativeExeSqlList);
    }

    @Override
    public boolean existTable(String schema, String table) {
        return this.commonRepository.existTable(schema, table);
    }

    @Override
    public <T> List<T> query(Class<T> clz) {
        String sql = this.getDialect().getSqlBuilder().buildSimpleQuery(clz);
        StatementHandler sh = this.getStatementHandler();
        if (sh != null) {
            sql = sh.handle(sql);
        }
        QueryMapper<T> mapper = ModelBuilder.buildQueryMapper(clz);
        return HbatisServiceManager.getHbatisService().use(this.commonRepository.getDatabase()).query(sql, mapper, new Object[0]);
    }

    @Override
    public <T> int update(T t) {
        return this.updateObject(t);
    }

    @Override
    public <T> int updateObject(T t) {
        if (t instanceof BaseModel) {
            ((BaseModel)t).setGmtModify(new Date());
        }
        Tuple tp = this.getDialect().getSqlBuilder().buildUpdateSQL(t);
        String sql = tp.getObject(0, String.class);
        StatementHandler sh = this.getStatementHandler();
        if (sh != null) {
            sql = sh.handle(sql);
        }
        Object[] params = tp.getObject(1, Object[].class);
        return HbatisServiceManager.getHbatisService().use(this.commonRepository.getDatabase()).update(sql, params);
    }

    @Override
    public <T> T get(BigInteger id, Class<T> clz) {
        return this.get(id, clz, false);
    }

    @Override
    public <T> T get(BigInteger id, Class<T> clz, boolean cached) {
        return this.get(id, clz, null, cached);
    }

    @Override
    public <T> T get(BigInteger id, Class<T> clz, String[] fields) {
        return this.get(id, clz, fields, false);
    }

    @Override
    public <T> T get(BigInteger id, Class<T> clz, String[] fields, boolean cached) {
        List<T> list = this.getObjectByField(Arrays.asList(Tuple.apply("id", id)), clz, fields, cached);
        return list != null && !list.isEmpty() ? (T)list.get(0) : null;
    }

    @Override
    public <T> T getObject(Object pk, Class<T> clz) {
        return this.getObjectByField(Tuple.apply("id", pk), clz);
    }

    @Override
    public <T> T getByNumber(String number, Class<T> clz) {
        return this.getByField(Tuple.apply("number", number), clz);
    }

    @Override
    public <T> T getObjectByNumber(String number, Class<T> clz) {
        List<T> list = this.getObjectByField(Arrays.asList(Tuple.apply("number", number)), clz);
        return list != null && !list.isEmpty() ? (T)list.get(0) : null;
    }

    @Override
    public <T> T getByField(Tuple kv, Class<T> clz) {
        List<T> fs = this.getByField(Arrays.asList(kv), clz);
        return fs != null && !fs.isEmpty() ? (T)fs.get(0) : null;
    }

    @Override
    public <T> T getObjectByField(Tuple kv, Class<T> clz) {
        List<T> list = this.getObjectByField(Arrays.asList(kv), clz);
        return list != null && !list.isEmpty() ? (T)list.get(0) : null;
    }

    @Override
    public <T> List<T> getByField(List<Tuple> kvList, Class<T> clz) {
        return this.getObjectByField(kvList, clz);
    }

    @Override
    public <T> List<T> getObjectByField(List<Tuple> kvList, Class<T> clz) {
        return this.getObjectByField(kvList, clz, false);
    }

    @Override
    public <T> List<T> getObjectByField(List<Tuple> kvList, Class<T> clz, boolean cached) {
        return this.getObjectByField(kvList, clz, null, cached);
    }

    @Override
    public <T> List<T> getObjectByField(List<Tuple> kvList, Class<T> clz, String[] fields) {
        return this.getObjectByField(kvList, clz, fields, false);
    }

    @Override
    public <T> List<T> getObjectByField(List<Tuple> kvList, Class<T> clz, String[] fields, boolean cached) {
        Tuple kv = this.getDialect().getSqlBuilder().buildQueryByFieldSQL(kvList, clz, fields);
        String sql = (String)kv.getObject(0);
        Object[] params = (Object[])kv.getObject(1);
        StatementHandler sh = this.getStatementHandler();
        GLog.debug("origin sql: {}, params: {}", sql, params);
        if (sh != null) {
            sql = sh.handle(sql);
            GLog.debug("changed sql: {} ", sql);
        }
        if (cached) {
            return this.querySqlListWithCache(sql, clz, params);
        }
        return this.querySqlList(sql, clz, params);
    }

    @Override
    public <T> int delete(T t) {
        Tuple tp = this.getDialect().getSqlBuilder().buildDeleteSQL(t);
        String sql = tp.getObject(0, String.class);
        StatementHandler sh = this.getStatementHandler();
        if (sh != null) {
            sql = sh.handle(sql);
        }
        Object[] params = tp.getObject(1, Object[].class);
        return HbatisServiceManager.getHbatisService().use(this.commonRepository.getDatabase()).update(sql, params);
    }

    @Override
    public <T> int delete(BigInteger id, Class<T> clz) {
        return this.deleteObject(id, clz);
    }

    @Override
    public <T> int delete(List<Tuple> kvList, Class<T> clz) {
        return this.deleteObject(kvList, clz);
    }

    @Override
    public <T> int deleteObject(Object pk, Class<T> clz) {
        return this.deleteObject(Arrays.asList(Tuple.apply("id", pk)), clz);
    }

    @Override
    public <T> int deleteObject(List<Tuple> kvList, Class<T> clz) {
        Tuple kv = this.getDialect().getSqlBuilder().buildDeleteByFieldSQL(kvList, clz);
        String sql = (String)kv.getObject(0);
        Object[] params = (Object[])kv.getObject(1);
        StatementHandler sh = this.getStatementHandler();
        if (sh != null) {
            sql = sh.handle(sql);
        }
        return HbatisServiceManager.getHbatisService().use(this.commonRepository.getDatabase()).update(sql, params);
    }

    @Override
    public <T extends GenericModel<Object>> T add(T t) {
        Tuple tp = this.getDialect().getSqlBuilder().buildInsertSQL(t);
        String sql = tp.getObject(0, String.class);
        StatementHandler sh = this.getStatementHandler();
        if (sh != null) {
            sql = sh.handle(sql);
        }
        Object[] params = tp.getObject(1, Object[].class);
        Object pk = HbatisServiceManager.getHbatisService().use(this.commonRepository.getDatabase()).save(sql, params);
        if (pk != null) {
            t.setId((Object)pk);
        }
        return t;
    }

    @Override
    public <T> Object addObject(T t) {
        return this.commonRepository.saveObject(t);
    }

    @Override
    public Object insert(String insertSql, Object ... params) {
        return this.commonRepository.insert(insertSql, params);
    }

    @Override
    public <T> boolean justAddObject(T t) {
        return this.commonRepository.saveObjectNoPk(t);
    }

    @Override
    public <T> boolean justAdd(T t) {
        if (t instanceof BaseModel) {
            BaseModel t1 = (BaseModel)t;
            if (t1.getGmtCreate() == null) {
                t1.setGmtCreate(new Date());
            }
            if (t1.getGmtModify() == null) {
                t1.setGmtModify(new Date());
            }
        }
        Tuple tp = this.getDialect().getSqlBuilder().buildInsertSQL(t);
        String sql = tp.getObject(0, String.class);
        StatementHandler sh = this.getStatementHandler();
        if (sh != null) {
            sql = sh.handle(sql);
        }
        Object[] params = tp.getObject(1, Object[].class);
        try {
            Object pk = HbatisServiceManager.getHbatisService().use(this.commonRepository.getDatabase()).save(sql, params);
            GLog.info("save with return pk:{}", pk);
        }
        catch (Exception e) {
            GLog.error("save error", e);
            return false;
        }
        return true;
    }

    @Override
    public <T> Page<T> queryPage(String sql, int pageNumber, int pageSize, Class<T> clz, Object ... params) {
        int i;
        Record r;
        int totalRow;
        String preSql = sql;
        Tuple t = this.getDialect().getSqlBuilder().buildPaginatorSql(preSql, pageNumber, pageSize);
        StatementHandler sh = this.getStatementHandler();
        String sqlCount = (String)t.getObject(0);
        if (sh != null) {
            sqlCount = sh.handle(sqlCount);
        }
        int n = totalRow = (r = this.commonRepository.queryRecord(sqlCount, params)) == null ? 0 : Integer.valueOf(r.get("totalCount").toString());
        if (totalRow == 0) {
            Page emptyPage = new Page();
            emptyPage.setPageSize(pageSize);
            return emptyPage;
        }
        int totalPage = totalRow / pageSize;
        if (totalRow % pageSize != 0) {
            ++totalPage;
        }
        String sqlLimit = (String)t.getObject(1);
        Object[] pms = (Object[])t.getObject(2);
        if (sh != null) {
            sqlLimit = sh.handle(sqlLimit);
        }
        int paramSize = params == null ? 0 : params.length;
        int pageParamSize = pms == null ? 0 : pms.length;
        int finalParamSize = paramSize + pageParamSize;
        Object[] finalParams = new Object[finalParamSize];
        if (paramSize > 0) {
            for (i = 0; i < paramSize; ++i) {
                finalParams[i] = params[i];
            }
        }
        if (pageParamSize > 0) {
            for (i = 0; i < pageParamSize; ++i) {
                finalParams[i + paramSize] = pms[i];
            }
        }
        List<T> dataList = this.commonRepository.queryList(sqlLimit, clz, finalParams);
        Page<T> page = new Page<T>(dataList, pageNumber, pageSize, totalPage, totalRow);
        return page;
    }

    @Override
    public <T> Page<T> queryPage(Class<T> clz, int pageNumber, int pageSize) {
        String sql = this.getDialect().getSqlBuilder().buildSimpleQuery(clz);
        return this.queryPage(sql, pageNumber, pageSize, clz, new Object[0]);
    }

    @Override
    public <T> Page<T> queryPage(Class<T> clz, int pageNumber) {
        return this.queryPage(clz, pageNumber, 16);
    }

    @Override
    public <T> Page<Record> queryPageRecords(String sql, int pageNumber, int pageSize, Object ... params) {
        int i;
        Record r;
        int totalRow;
        String preSql = sql;
        Tuple t = this.getDialect().getSqlBuilder().buildPaginatorSql(preSql, pageNumber, pageSize);
        StatementHandler sh = this.getStatementHandler();
        String sqlCount = (String)t.getObject(0);
        if (sh != null) {
            sqlCount = sh.handle(sqlCount);
        }
        int n = totalRow = (r = this.commonRepository.queryRecord(sqlCount, params)) == null ? 0 : Integer.valueOf(r.get("totalCount").toString());
        if (totalRow == 0) {
            Page<Record> emptyPage = new Page<Record>();
            emptyPage.setPageSize(pageSize);
            return emptyPage;
        }
        int totalPage = totalRow / pageSize;
        if (totalRow % pageSize != 0) {
            ++totalPage;
        }
        String sqlLimit = (String)t.getObject(1);
        Object[] pms = (Object[])t.getObject(2);
        if (sh != null) {
            sqlLimit = sh.handle(sqlLimit);
        }
        int paramSize = params == null ? 0 : params.length;
        int pageParamSize = pms == null ? 0 : pms.length;
        int finalParamSize = paramSize + pageParamSize;
        Object[] finalParams = new Object[finalParamSize];
        if (paramSize > 0) {
            for (i = 0; i < paramSize; ++i) {
                finalParams[i] = params[i];
            }
        }
        if (pageParamSize > 0) {
            for (i = 0; i < pageParamSize; ++i) {
                finalParams[i + paramSize] = pms[i];
            }
        }
        List<Record> dataList = this.commonRepository.queryRecords(sqlLimit, finalParams);
        Page<Record> page = new Page<Record>(dataList, pageNumber, pageSize, totalPage, totalRow);
        return page;
    }

    @Override
    public <T> Page<Record> queryPageRecords(Class<T> clz, int pageNumber, int pageSize) {
        String preSql = this.getDialect().getSqlBuilder().buildSimpleQuery(clz);
        return this.queryPageRecords(preSql, pageNumber, pageSize, new Object[0]);
    }

    @Override
    public <T> Page<Record> queryPageRecords(Class<T> clz, int pageNumber) {
        return this.queryPageRecords(clz, pageNumber, 16);
    }

    @Override
    public <T> List<T> queryWithCache(Class<T> clz) {
        String sql = this.getDialect().getSqlBuilder().buildSimpleQuery(clz);
        StatementHandler sh = this.getStatementHandler();
        if (sh != null) {
            sql = sh.handle(sql);
        }
        return this.querySqlListWithCache(sql, clz, new Object[0]);
    }

    @Override
    public <T> List<T> querySqlList(String sql, Class<T> clz, Object ... params) {
        return this.commonRepository.queryList(sql, clz, params);
    }

    @Override
    public <T> List<T> querySqlListWithCache(String nativeSql, Class<T> clz, Object ... params) {
        return this.commonRepository.queryListWithCache(nativeSql, clz, params);
    }

    @Override
    public List<Record> querySqlRecordsWithCache(String sql, Object ... params) {
        return this.commonRepository.queryRecordsWithCache(sql, params);
    }
}

