/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ds;

import cn.sylinx.hbatis.ds.JdbcResource;
import cn.sylinx.hbatis.ds.JdbcResourceWrapper;
import cn.sylinx.hbatis.log.GLog;
import java.util.HashMap;
import java.util.Map;

public enum JdbcResourceManager {
    me;

    private Map<String, JdbcResourceWrapper> resourceList = new HashMap<String, JdbcResourceWrapper>();
    private String defaultJdbcResourceName = null;

    public static JdbcResourceManager get() {
        return me;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJdbcResource(JdbcResourceWrapper jdbcResource) {
        JdbcResourceManager jdbcResourceManager = me;
        synchronized (jdbcResourceManager) {
            if (this.resourceList.containsKey(jdbcResource.getResourceName())) {
                GLog.info("jdbc resource name {} override", jdbcResource.getResourceName());
            }
            this.resourceList.put(jdbcResource.getResourceName(), jdbcResource);
            if (jdbcResource.isDefaultResource()) {
                this.defaultJdbcResourceName = jdbcResource.getResourceName();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJdbcResource(String jdbResourceName) {
        JdbcResourceManager jdbcResourceManager = me;
        synchronized (jdbcResourceManager) {
            if (!this.resourceList.containsKey(jdbResourceName)) {
                GLog.info("jdbc resource name {} not exist", jdbResourceName);
            } else {
                JdbcResourceWrapper jrw = this.resourceList.remove(jdbResourceName);
                jrw.clear();
                Object var3_3 = null;
            }
        }
    }

    public String getDefaultJdbcResourceName() {
        if (this.defaultJdbcResourceName != null) {
            return this.defaultJdbcResourceName;
        }
        if (this.resourceList.isEmpty()) {
            throw new RuntimeException("jdbc resource is empty");
        }
        JdbcResourceWrapper jrw = this.useDefaultJdbcResourceWrapper();
        if (jrw == null) {
            throw new RuntimeException("not config default jdbc resource");
        }
        return jrw.getResourceName();
    }

    public JdbcResource get(String jdbcResourceName) {
        JdbcResourceWrapper jrw = this.resourceList.get(jdbcResourceName);
        return jrw != null ? jrw.getJdbcResource() : null;
    }

    public JdbcResource useDefault() {
        JdbcResourceWrapper jrw;
        if (this.defaultJdbcResourceName != null && (jrw = this.resourceList.get(this.defaultJdbcResourceName)) != null) {
            return jrw.getJdbcResource();
        }
        jrw = this.useDefaultJdbcResourceWrapper();
        if (jrw != null) {
            return jrw.getJdbcResource();
        }
        throw new RuntimeException("not config default jdbc resource");
    }

    JdbcResourceWrapper useDefaultJdbcResourceWrapper() {
        for (Map.Entry<String, JdbcResourceWrapper> entry : this.resourceList.entrySet()) {
            JdbcResourceWrapper jrw = entry.getValue();
            if (!jrw.isDefaultResource()) continue;
            this.defaultJdbcResourceName = jrw.getResourceName();
            return jrw;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        JdbcResourceManager jdbcResourceManager = me;
        synchronized (jdbcResourceManager) {
            this.resourceList.clear();
        }
    }
}

