/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.plugin.ehcache;

import cn.sylinx.hbatis.plugin.IPlugin;
import cn.sylinx.hbatis.plugin.ehcache.CacheKit;
import java.io.InputStream;
import java.net.URL;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;

public class EhcachePlugin
implements IPlugin {
    private static CacheManager cacheManager;
    private String configurationFileName;
    private URL configurationFileURL;
    private InputStream inputStream;
    private Configuration configuration;

    public void setConfigurationFileName(String configurationFileName) {
        this.configurationFileName = configurationFileName;
    }

    public void setConfigurationFileURL(URL configurationFileURL) {
        this.configurationFileURL = configurationFileURL;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public EhcachePlugin() {
    }

    public EhcachePlugin(CacheManager cacheManager) {
        EhcachePlugin.cacheManager = cacheManager;
    }

    public EhcachePlugin(String configurationFileName) {
        this.configurationFileName = configurationFileName;
    }

    public EhcachePlugin(URL configurationFileURL) {
        this.configurationFileURL = configurationFileURL;
    }

    public EhcachePlugin(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public EhcachePlugin(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean start(Object ... objects) {
        this.createCacheManager();
        CacheKit.init(cacheManager);
        return true;
    }

    private void createCacheManager() {
        if (cacheManager != null) {
            return;
        }
        if (this.configurationFileName != null) {
            cacheManager = CacheManager.create((String)this.configurationFileName);
            return;
        }
        if (this.configurationFileURL != null) {
            cacheManager = CacheManager.create((URL)this.configurationFileURL);
            return;
        }
        if (this.inputStream != null) {
            cacheManager = CacheManager.create((InputStream)this.inputStream);
            return;
        }
        if (this.configuration != null) {
            cacheManager = CacheManager.create((Configuration)this.configuration);
            return;
        }
        cacheManager = CacheManager.create();
    }

    @Override
    public boolean stop() {
        cacheManager.shutdown();
        CacheKit.destory();
        cacheManager = null;
        return true;
    }
}

