/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.plugin.ehcache;

import cn.sylinx.hbatis.db.cache.IDataLoader;
import cn.sylinx.hbatis.log.GLog;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public final class CacheKit {
    public static final String DEFAULT_CACHENAME = "hbatis_default_cache";
    private static CacheManager cacheManager;
    private static AtomicBoolean inited;

    public static boolean isInited() {
        return inited.get();
    }

    static void init(CacheManager cacheManager) {
        CacheKit.cacheManager = cacheManager;
        inited.set(true);
    }

    static void destory() {
        cacheManager = null;
        inited.set(false);
    }

    public static CacheManager getCacheManager() {
        return cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Cache getOrAddCache(String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            CacheManager cacheManager = CacheKit.cacheManager;
            synchronized (cacheManager) {
                cache = CacheKit.cacheManager.getCache(cacheName);
                if (cache == null) {
                    GLog.info("Could not find cache config [" + cacheName + "], using default.", new Object[0]);
                    CacheKit.cacheManager.addCacheIfAbsent(cacheName);
                    cache = CacheKit.cacheManager.getCache(cacheName);
                    GLog.debug("Cache [" + cacheName + "] started.", new Object[0]);
                }
            }
        }
        return cache;
    }

    public static void put(String cacheName, Object key, Object value) {
        CacheKit.getOrAddCache(cacheName).put(new Element(key, value));
    }

    public static <T> T get(String cacheName, Object key) {
        Element element = CacheKit.getOrAddCache(cacheName).get(key);
        return (T)(element != null ? element.getObjectValue() : null);
    }

    public static List getKeys(String cacheName) {
        return CacheKit.getOrAddCache(cacheName).getKeys();
    }

    public static void remove(String cacheName, Object key) {
        CacheKit.getOrAddCache(cacheName).remove(key);
    }

    public static void removeAll(String cacheName) {
        CacheKit.getOrAddCache(cacheName).removeAll();
    }

    public static <T> T get(String cacheName, Object key, IDataLoader<?> dataLoader) {
        Object data = CacheKit.get(cacheName, key);
        if (data == null) {
            data = dataLoader.load();
            CacheKit.put(cacheName, key, data);
        }
        return data;
    }

    public static <T> T get(String cacheName, Object key, Class<? extends IDataLoader<?>> dataLoaderClass) {
        Object data = CacheKit.get(cacheName, key);
        if (data == null) {
            try {
                IDataLoader<?> dataLoader = dataLoaderClass.newInstance();
                data = dataLoader.load();
                CacheKit.put(cacheName, key, data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return data;
    }

    static {
        inited = new AtomicBoolean(false);
    }
}

