/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.xmapper;

import cn.sylinx.hbatis.db.common.DbOper;
import cn.sylinx.hbatis.db.common.DefaultHbatisService;
import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import cn.sylinx.hbatis.ext.parse.SqlParser;
import cn.sylinx.hbatis.ext.res.StatementHandler;
import cn.sylinx.hbatis.ext.xmapper.DefaultXmapperCacheQuery;
import cn.sylinx.hbatis.ext.xmapper.XmapperCacheQuery;
import cn.sylinx.hbatis.ext.xmapper.XmapperService;
import cn.sylinx.hbatis.ext.xmapper.xml.QueryMapping;
import cn.sylinx.hbatis.ext.xmapper.xml.Sql;
import cn.sylinx.hbatis.ext.xmapper.xml.SqlForUse;
import cn.sylinx.hbatis.ext.xmapper.xml.XmlSqlMapper;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.kit.Tuple;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class DefaultXmapperService
extends DefaultHbatisService
implements XmapperService {
    private String datasourceName;
    private final XmapperCacheQuery xmapperCacheQuery;
    private final Map<String, XmapperService> dbServiceMap = new WeakHashMap<String, XmapperService>();

    public DefaultXmapperService() {
        this("hbatisDefaultJdbcResource");
    }

    public DefaultXmapperService(String datasourceName) {
        super(datasourceName);
        this.datasourceName = datasourceName;
        this.xmapperCacheQuery = this.createXmapperCacheQuery(new Object[0]);
        this.dbServiceMap.put(datasourceName, this);
    }

    private XmapperCacheQuery createXmapperCacheQuery(Object ... params) {
        return new DefaultXmapperCacheQuery(this.getCacheQuery());
    }

    @Override
    public XmapperCacheQuery withXmapperCache() {
        if (this.getCacheQuery() == null || this.xmapperCacheQuery == null) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7f13\u5b58\u67e5\u8be2");
        }
        return this.xmapperCacheQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XmapperService useService(String datasourceName) {
        XmapperService dbService = this.dbServiceMap.get(datasourceName);
        if (dbService == null) {
            String string = datasourceName.intern();
            synchronized (string) {
                this.createInstanceInner(datasourceName);
            }
            dbService = this.dbServiceMap.get(datasourceName);
        }
        return dbService;
    }

    private void createInstanceInner(String datasourceName) {
        XmapperService dbService = this.dbServiceMap.get(datasourceName);
        if (dbService == null) {
            dbService = this.createInstance(datasourceName);
            this.dbServiceMap.put(datasourceName, dbService);
        }
    }

    protected XmapperService createInstance(String datasourceName) {
        return new DefaultXmapperService(datasourceName);
    }

    @Override
    public DbOper getDbOper() {
        return this;
    }

    @Override
    public <T> List<T> query(String sqlId, Map<String, Object> params) {
        String[] ids = sqlId.split("\\.");
        String namespaceId = ids[0];
        String id = ids[1];
        return this.query(namespaceId, id, params);
    }

    @Override
    public Map<String, Object> queryFirstForMap(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.QUERY.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not query for use");
        }
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).queryFirstMap(st, pms);
    }

    @Override
    public Map<String, Object> queryFirstForMap(String sqlId, Map<String, Object> params) {
        String[] ids = sqlId.split("\\.");
        String namespaceId = ids[0];
        String id = ids[1];
        return this.queryFirstForMap(namespaceId, id, params);
    }

    @Override
    public List<Map<String, Object>> queryForMapList(String sqlId, Map<String, Object> params) {
        String[] ids = sqlId.split("\\.");
        String namespaceId = ids[0];
        String id = ids[1];
        return this.queryForMapList(namespaceId, id, params);
    }

    @Override
    public List<Record> queryForRecords(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.QUERY.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not query for use");
        }
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).queryRecords(st, pms);
    }

    @Override
    public List<Record> queryForRecords(String sqlId, Map<String, Object> params) {
        String[] ids = sqlId.split("\\.");
        String namespaceId = ids[0];
        String id = ids[1];
        return this.queryForRecords(namespaceId, id, params);
    }

    @Override
    public Record queryFirstRecord(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.QUERY.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not query for use");
        }
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).queryFirstRecord(st, pms);
    }

    @Override
    public Record queryFirstRecord(String sqlId, Map<String, Object> params) {
        String[] ids = sqlId.split("\\.");
        String namespaceId = ids[0];
        String id = ids[1];
        return this.queryFirstRecord(namespaceId, id, params);
    }

    @Override
    public List<Object[]> queryObjectArrayList(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.QUERY.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not query for use");
        }
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).query(st, pms);
    }

    @Override
    public List<Object[]> queryObjectArrayList(String sqlId, Map<String, Object> params) {
        String[] ids = sqlId.split("\\.");
        String namespaceId = ids[0];
        String id = ids[1];
        return this.queryObjectArrayList(namespaceId, id, params);
    }

    private Tuple getQueryStatement(String statement, Map<String, Object> params) {
        Object obj;
        StatementHandler sqlHandler = null;
        if (params != null && (obj = params.get(StatementHandler.class.getName())) != null && obj instanceof StatementHandler) {
            sqlHandler = (StatementHandler)obj;
        }
        return SqlParser.parseSql(statement, params, sqlHandler);
    }

    @Override
    public Object[] queryFirstObjectArray(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.QUERY.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not query for use");
        }
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).queryFirst(st, pms);
    }

    @Override
    public Object[] queryFirstObjectArray(String sqlId, Map<String, Object> params) {
        String[] ids = sqlId.split("\\.");
        String namespaceId = ids[0];
        String id = ids[1];
        return this.queryFirstObjectArray(namespaceId, id, params);
    }

    @Override
    public List<Map<String, Object>> queryForMapList(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.QUERY.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not query for use");
        }
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).queryMap(st, pms);
    }

    @Override
    public <T> List<T> query(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.QUERY.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not query for use");
        }
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        final QueryMapping qm = sql.getQueryMapping();
        QueryMapper qmapper = null;
        if (qm != null) {
            qmapper = new QueryMapper<T>(){

                @Override
                public Map<String, String> getJdbcToJavaMapper() {
                    return qm.getMap();
                }

                @Override
                public Class<T> getValueObjectClass() {
                    try {
                        String clzStr = qm.getReturnClass();
                        if (StrKit.isNotBlank(clzStr)) {
                            return Class.forName(clzStr);
                        }
                        return null;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            };
        }
        return this.useService(this.datasourceName).query(st, qmapper, pms);
    }

    @Override
    public <T> T queryFirst(String sqlId, Map<String, Object> params) {
        List<T> list = this.query(sqlId, params);
        return list != null && !list.isEmpty() ? (T)list.get(0) : null;
    }

    @Override
    public <T> T queryFirst(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.QUERY.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not query for use");
        }
        final QueryMapping qm = sql.getQueryMapping();
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String st = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        QueryMapper qmapper = null;
        if (qm != null) {
            qmapper = new QueryMapper<T>(){

                @Override
                public Map<String, String> getJdbcToJavaMapper() {
                    return qm.getMap();
                }

                @Override
                public Class<T> getValueObjectClass() {
                    try {
                        String clzStr = qm.getReturnClass();
                        if (StrKit.isNotBlank(clzStr)) {
                            return Class.forName(clzStr);
                        }
                        return null;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            };
        }
        return this.useService(this.datasourceName).queryFirst(st, qmapper, pms);
    }

    @Override
    public int update(String sqlId, Map<String, Object> params) {
        String[] ids = sqlId.split("\\.");
        String namespaceId = ids[0];
        String id = ids[1];
        return this.update(namespaceId, id, params);
    }

    @Override
    public int update(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.UPDATE.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not update for use");
        }
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String updateSql = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).update(updateSql, pms);
    }

    @Override
    public int delete(String sqlId, Map<String, Object> params) {
        String[] ids = sqlId.split("\\.");
        String namespaceId = ids[0];
        String id = ids[1];
        return this.delete(namespaceId, id, params);
    }

    @Override
    public int delete(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.DELETE.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not delete for use");
        }
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String deleteSql = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).update(deleteSql, pms);
    }

    @Override
    public Object save(String sqlId, Map<String, Object> params) {
        String[] ids = sqlId.split("\\.");
        String namespaceId = ids[0];
        String id = ids[1];
        return this.save(namespaceId, id, params);
    }

    @Override
    public Object save(String namespaceId, String id, Map<String, Object> params) {
        if (!XmlSqlMapper.get().isInited()) {
            throw new RuntimeException("xmlSqlmapper plugin not started~");
        }
        Sql sql = XmlSqlMapper.get().getSqlBySqlId(namespaceId, id);
        String forUse = sql.getForUse();
        if (!SqlForUse.INSERT.getCode().equals(forUse)) {
            throw new IllegalArgumentException("sql is not insert for use");
        }
        Tuple tp = this.getQueryStatement(sql.getStatement(), params);
        String insertSql = (String)tp.get(0);
        Object[] pms = (Object[])tp.get(1);
        return this.useService(this.datasourceName).save(insertSql, pms);
    }
}

