/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ds;

import cn.sylinx.hbatis.db.dialect.DbType;
import cn.sylinx.hbatis.ds.Resource;
import cn.sylinx.hbatis.log.GLog;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class JdbcResource
implements Resource<Connection> {
    private DataSource dataSource;
    private String dataSourceName;
    private DbType dbType;
    private final ThreadLocal<Connection> transactionConnections = new ThreadLocal();

    public JdbcResource(String dataSourceName, DataSource dataSource, DbType dbType) {
        this.dataSource = dataSource;
        this.dataSourceName = dataSourceName;
        this.dbType = dbType;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public final void setTransactionConnection(Connection connection) {
        this.transactionConnections.set(connection);
    }

    public final Connection getTransactionConnection() {
        return this.transactionConnections.get();
    }

    public final void removeTransactionConnection() {
        this.transactionConnections.remove();
    }

    @Override
    public Connection get() {
        Connection conn = this.transactionConnections.get();
        if (conn != null) {
            return conn;
        }
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            GLog.error("dataSource.getConnection() error: ", e);
            return null;
        }
    }

    @Override
    public void close(Connection resource) {
        if (this.transactionConnections.get() == null && resource != null) {
            try {
                resource.close();
            }
            catch (SQLException e) {
                GLog.error("resource.close() error: ", e);
            }
        }
    }
}

