/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.db.mapper;

import cn.sylinx.hbatis.db.mapper.DeleteMapper;
import cn.sylinx.hbatis.db.mapper.InsertMapper;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import cn.sylinx.hbatis.db.mapper.UpdateMapper;
import cn.sylinx.hbatis.db.mapper.anno.PrimaryKey;
import cn.sylinx.hbatis.db.mapper.anno.Table;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.plugin.model.ModelCacheManager;
import cn.sylinx.hbatis.plugin.model.ModelFabric;
import cn.sylinx.hbatis.type.TypeHandler;
import cn.sylinx.hbatis.type.TypeHandlerRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelBuilder {
    public static <T> InsertMapper<T> buildInsertMapper(T t) {
        Class<?> clz = t.getClass();
        final ModelFabric mf = ModelBuilder.getModelFabric(clz);
        final String table = mf.getTableName();
        if (StrKit.isBlank(table)) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8868\u4e3a\u7a7a");
        }
        InsertMapper mapper = new InsertMapper<T>(){

            @Override
            public String getTableName() {
                return table;
            }

            @Override
            public Map<String, String> getJavaToJdbcMapper() {
                return mf.getAttrMapping();
            }
        };
        return mapper;
    }

    public static <T> T buildFirstQueryModel(ResultSet rs, QueryMapper<T> mapper) throws SQLException, InstantiationException, IllegalAccessException {
        if (mapper == null) {
            return null;
        }
        T result = null;
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        ModelBuilder.buildColumnNamesAndTypes(rsmd, labelNames, types);
        Map<String, String> maps = mapper.getJdbcToJavaMapper();
        Class<T> clz = mapper.getValueObjectClass();
        if (clz == null) {
            return null;
        }
        ModelFabric mf = ModelBuilder.getModelFabric(clz.getName());
        boolean ismapsEmpty = maps == null || maps.isEmpty();
        boolean ismappingEmpty = mf.isMappingEmpty();
        if (ismapsEmpty && ismappingEmpty) {
            if (rs.next()) {
                TypeHandler<T> th = TypeHandlerRegistry.getInstance().getTypeHandler(clz);
                T tmp1 = th.getResult(rs, 1);
                result = tmp1;
            }
        } else {
            if (ismapsEmpty) {
                maps = mf.getJdbcMapping();
            }
            Map<String, Field> fieldMap = mf.getFieldMap();
            if (rs.next()) {
                T instance = clz.newInstance();
                for (int i = 1; i <= columnCount; ++i) {
                    Field f = fieldMap.get(maps.get(labelNames[i]));
                    if (f == null) continue;
                    Class<?> cls = f.getType();
                    TypeHandler<?> th = TypeHandlerRegistry.getInstance().getTypeHandler(cls);
                    Object tmp1 = th.getResult(rs, i);
                    if (tmp1 == null) continue;
                    f.setAccessible(true);
                    f.set(instance, tmp1);
                }
                result = instance;
            }
        }
        return result;
    }

    public static <T> UpdateMapper<T> buildUpdateMapper(T t) {
        Class<?> clz = t.getClass();
        final ModelFabric mf = ModelBuilder.getModelFabric(clz);
        final String table = mf.getTableName();
        if (StrKit.isBlank(table)) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8868\u4e3a\u7a7a");
        }
        final PrimaryKey pks = mf.getPrimaryKey();
        UpdateMapper mapper = new UpdateMapper<T>(){

            @Override
            public String getTableName() {
                return table;
            }

            @Override
            public Map<String, String> getJavaToJdbcMapper() {
                return mf.getAttrMapping();
            }

            @Override
            public List<String> getPrimaryKeyFieldNameList() {
                ArrayList<String> pklist = new ArrayList<String>();
                if (pks != null) {
                    String[] pkArray;
                    for (String pk : pkArray = pks.value()) {
                        if (!StrKit.isNotBlank(pk)) continue;
                        pklist.add(pk);
                    }
                }
                if (pklist.isEmpty()) {
                    pklist.add("id");
                }
                return pklist;
            }
        };
        return mapper;
    }

    public static <T> DeleteMapper<T> buildDeleteMapper(T t) {
        Class<?> clz = t.getClass();
        final ModelFabric mf = ModelBuilder.getModelFabric(clz);
        final String table = mf.getTableName();
        if (StrKit.isBlank(table)) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8868\u4e3a\u7a7a");
        }
        final PrimaryKey pks = mf.getPrimaryKey();
        DeleteMapper mapper = new DeleteMapper<T>(){

            @Override
            public String getTableName() {
                return table;
            }

            @Override
            public Map<String, String> getJavaToJdbcMapper() {
                return mf.getAttrMapping();
            }

            @Override
            public List<String> getPrimaryKeyFieldNameList() {
                ArrayList<String> pklist = new ArrayList<String>();
                if (pks != null) {
                    String[] pkArray;
                    for (String pk : pkArray = pks.value()) {
                        if (!StrKit.isNotBlank(pk)) continue;
                        pklist.add(pk);
                    }
                }
                if (pklist.isEmpty()) {
                    pklist.add("id");
                }
                return pklist;
            }
        };
        return mapper;
    }

    public static <T> QueryMapper<T> buildQueryMapper(final Class<T> clz) {
        final ModelFabric mf = ModelBuilder.getModelFabric(clz);
        if (mf.isMappingEmpty()) {
            return null;
        }
        QueryMapper t = new QueryMapper<T>(){

            @Override
            public Map<String, String> getJdbcToJavaMapper() {
                return mf.getJdbcMapping();
            }

            @Override
            public Class<T> getValueObjectClass() {
                return clz;
            }
        };
        return t;
    }

    public static <T> List<T> buildQueryModel(ResultSet rs, QueryMapper<T> mapper) throws SQLException, InstantiationException, IllegalAccessException {
        ArrayList<T> result = new ArrayList<T>();
        if (mapper == null) {
            return result;
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        ModelBuilder.buildColumnNamesAndTypes(rsmd, labelNames, types);
        Map<String, String> maps = mapper.getJdbcToJavaMapper();
        Class<T> clz = mapper.getValueObjectClass();
        if (clz == null) {
            return null;
        }
        ModelFabric mf = ModelBuilder.getModelFabric(clz.getName());
        Map<String, Field> fieldMap = mf.getFieldMap();
        boolean ismapsEmpty = maps == null || maps.isEmpty();
        boolean ismappingEmpty = mf.isMappingEmpty();
        if (ismapsEmpty && ismappingEmpty) {
            while (rs.next()) {
                TypeHandler<T> th = TypeHandlerRegistry.getInstance().getTypeHandler(clz);
                T tmp1 = th.getResult(rs, 1);
                result.add(tmp1);
            }
        } else {
            if (ismapsEmpty) {
                maps = mf.getJdbcMapping();
            }
            while (rs.next()) {
                T instance = clz.newInstance();
                for (int i = 1; i <= columnCount; ++i) {
                    Field f = fieldMap.get(maps.get(labelNames[i]));
                    if (f == null) continue;
                    Class<?> cls = f.getType();
                    TypeHandler<?> th = TypeHandlerRegistry.getInstance().getTypeHandler(cls);
                    Object tmp1 = th.getResult(rs, i);
                    if (tmp1 == null) continue;
                    f.setAccessible(true);
                    f.set(instance, tmp1);
                }
                result.add(instance);
            }
        }
        return result;
    }

    private static final void buildColumnNamesAndTypes(ResultSetMetaData rsmd, String[] labelNames, int[] types) throws SQLException {
        for (int i = 1; i < labelNames.length; ++i) {
            labelNames[i] = rsmd.getColumnLabel(i);
            types[i] = rsmd.getColumnType(i);
        }
    }

    public static List<Field> getObjectAllFieldsWithcache(Class<?> cclz) {
        ModelFabric mf = ModelBuilder.getModelFabric(cclz);
        return mf.getFields();
    }

    public static Map<String, Field> getObjectAllFieldsMapWithcache(Class<?> cclz) {
        ModelFabric mf = ModelBuilder.getModelFabric(cclz);
        return mf.getFieldMap();
    }

    public static List<Field> getObjectAllFields(Class<?> cclz) {
        List<Field> fds1;
        Class<?> pclz;
        ArrayList<Field> fields = new ArrayList<Field>();
        Field[] fs = cclz.getDeclaredFields();
        if (fs != null && fs.length > 0) {
            for (Field f : fs) {
                String modifiers = Modifier.toString(f.getModifiers());
                if (modifiers.contains("final") || modifiers.contains("static")) continue;
                fields.add(f);
            }
        }
        if ((pclz = cclz.getSuperclass()) != null && !pclz.isInterface() && (fds1 = ModelBuilder.getObjectAllFields(pclz)) != null && !fds1.isEmpty()) {
            fields.addAll(fds1);
        }
        return fields;
    }

    public static Map<String, Field> getObjectAllFieldsMap(Class<?> cclz) {
        Map<String, Field> fds1;
        Class<?> pclz;
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Field[] fs = cclz.getDeclaredFields();
        if (fs != null && fs.length > 0) {
            for (Field f : fs) {
                String modifiers = Modifier.toString(f.getModifiers());
                if (modifiers.contains("final") || modifiers.contains("static")) continue;
                fields.put(f.getName(), f);
                fields.put(f.getName().toUpperCase(), f);
            }
        }
        if ((pclz = cclz.getSuperclass()) != null && !pclz.isInterface() && (fds1 = ModelBuilder.getObjectAllFieldsMap(pclz)) != null && !fds1.isEmpty()) {
            fields.putAll(fds1);
        }
        return fields;
    }

    public static ModelFabric getModelFabric(String clzStr) {
        return ModelCacheManager.get().getModelFabric(clzStr);
    }

    public static String getModelTable(Class<?> clz) {
        Table table = clz.getAnnotation(Table.class);
        return table != null ? table.value() : null;
    }

    public static ModelFabric getModelFabric(Class<?> clz) {
        return ModelCacheManager.get().getModelFabric(clz);
    }
}

