/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.db.dialect.sql;

import cn.sylinx.hbatis.db.dialect.DbType;
import cn.sylinx.hbatis.db.dialect.sql.DefaultSqlBuilder;
import cn.sylinx.hbatis.db.dialect.sql.DerbySqlBuilder;
import cn.sylinx.hbatis.db.dialect.sql.MysqlSqlBuilder;
import cn.sylinx.hbatis.db.dialect.sql.OracleSqlBuilder;
import cn.sylinx.hbatis.db.dialect.sql.SqlServerSqlBuilder;
import cn.sylinx.hbatis.db.mapper.sql.SqlBuilder;
import java.util.HashMap;
import java.util.Map;

public class SqlBuilderFactory {
    private final Map<DbType, SqlBuilder> registers = new HashMap<DbType, SqlBuilder>();
    private static final SqlBuilderFactory instance = new SqlBuilderFactory();

    public static SqlBuilderFactory get() {
        return instance;
    }

    private SqlBuilderFactory() {
        this.registerDefault();
    }

    private void registerDefault() {
        this.register(DbType.MYSQL, new MysqlSqlBuilder());
        this.register(DbType.ORACLE, new OracleSqlBuilder());
        this.register(DbType.SQLSERVER, new SqlServerSqlBuilder());
        this.register(DbType.DERBY, new DerbySqlBuilder());
        this.register(DbType.DB2, new DefaultSqlBuilder());
    }

    public void register(DbType dbType, SqlBuilder sqlBuilder) {
        this.registers.put(dbType, sqlBuilder);
    }

    public SqlBuilder getSqlBuilder(DbType dbType) {
        SqlBuilder sb = this.registers.get((Object)dbType);
        if (sb == null) {
            sb = new DefaultSqlBuilder();
        }
        return sb;
    }
}

