/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.db.dialect.sql;

import cn.sylinx.hbatis.db.mapper.DeleteMapper;
import cn.sylinx.hbatis.db.mapper.InsertMapper;
import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.db.mapper.UpdateMapper;
import cn.sylinx.hbatis.db.mapper.sql.SqlBuilder;
import cn.sylinx.hbatis.exception.ExecutingException;
import cn.sylinx.hbatis.ext.model.Model;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.kit.Tuple;
import cn.sylinx.hbatis.log.GLog;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultSqlBuilder
implements SqlBuilder {
    @Override
    public <T> Tuple buildDeleteSQL(T t) {
        DeleteMapper<T> mapper = ModelBuilder.buildDeleteMapper(t);
        if (mapper == null) {
            return null;
        }
        String tableName = mapper.getTableName();
        List<String> pks = mapper.getPrimaryKeyFieldNameList();
        Map<String, String> map = mapper.getJavaToJdbcMapper();
        if (StrKit.isBlank(tableName)) {
            GLog.error("table name is empty~", new Object[0]);
            return null;
        }
        if (pks == null || pks.isEmpty()) {
            GLog.error("primary key is empty~", new Object[0]);
            return null;
        }
        if (map == null || map.isEmpty()) {
            GLog.error("java to jdbc mapper is empty~", new Object[0]);
            return null;
        }
        String token = " and ";
        List<Field> fields = ModelBuilder.getObjectAllFieldsWithcache(t.getClass());
        StringBuilder sql = new StringBuilder("delete from " + tableName + " where ");
        boolean find = false;
        ArrayList<Object> params = new ArrayList<Object>();
        try {
            for (Field item : fields) {
                String fieldName = item.getName();
                if (!pks.contains(fieldName)) continue;
                String f = map.get(fieldName);
                item.setAccessible(true);
                Object v = item.get(t);
                if (f == null || v == null) continue;
                find = true;
                sql.append(f).append(" = ? ").append(" and ");
                params.add(v);
            }
        }
        catch (IllegalAccessException e) {
            throw new ExecutingException(e);
        }
        if (!find) {
            return null;
        }
        int totalLen = sql.length();
        int index = sql.length() - " and ".length();
        sql.delete(index, totalLen);
        Object[] objects = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            objects[i] = params.get(i);
        }
        String sqlNative = sql.toString();
        GLog.debug("sql:{} , params:{}", sqlNative, objects);
        return Tuple.apply(sqlNative, objects);
    }

    @Override
    public <T> Tuple buildInsertSQL(T t) {
        InsertMapper<T> mapper = ModelBuilder.buildInsertMapper(t);
        if (mapper == null) {
            return null;
        }
        Map<String, String> map = mapper.getJavaToJdbcMapper();
        String tableName = mapper.getTableName();
        if (map == null || map.isEmpty()) {
            GLog.error("insert mapper is empty~", new Object[0]);
            return null;
        }
        if (StrKit.isBlank(tableName)) {
            GLog.error("table name is empty~", new Object[0]);
            return null;
        }
        List<Field> fields = ModelBuilder.getObjectAllFieldsWithcache(t.getClass());
        if (fields.isEmpty()) {
            return null;
        }
        StringBuilder fds = new StringBuilder();
        StringBuilder fdsv = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        fds.append("(");
        fdsv.append("(");
        try {
            for (Field item : fields) {
                String fieldName = item.getName();
                if (!map.containsKey(fieldName)) continue;
                item.setAccessible(true);
                Object v = item.get(t);
                if (v == null || "".equals(v.toString().trim())) continue;
                String jdbcFieldName = map.get(fieldName);
                fds.append(jdbcFieldName).append(",");
                fdsv.append("?,");
                params.add(v);
            }
        }
        catch (IllegalAccessException e) {
            throw new ExecutingException(e);
        }
        if (fds.length() <= 1) {
            return null;
        }
        fds.deleteCharAt(fds.length() - 1);
        fdsv.deleteCharAt(fdsv.length() - 1);
        fds.append(")");
        fdsv.append(")");
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append(tableName).append((CharSequence)fds).append(" values ").append((CharSequence)fdsv);
        Object[] objects = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            objects[i] = params.get(i);
        }
        String sql = sb.toString();
        GLog.debug("sql:{} , params:{}", sql, objects);
        return Tuple.apply(sql, objects);
    }

    @Override
    public <T> Tuple buildUpdateSQL(T t) {
        List<Field> fields;
        UpdateMapper<T> mapper = ModelBuilder.buildUpdateMapper(t);
        if (mapper == null) {
            return null;
        }
        Map<String, String> map = mapper.getJavaToJdbcMapper();
        List<String> pks = mapper.getPrimaryKeyFieldNameList();
        String tableName = mapper.getTableName();
        if (map == null || map.isEmpty()) {
            GLog.error("update mapper is empty~", new Object[0]);
            return null;
        }
        if (StrKit.isBlank(tableName)) {
            GLog.error("table name is empty~", new Object[0]);
            return null;
        }
        if (pks == null) {
            pks = Collections.emptyList();
        }
        if ((fields = ModelBuilder.getObjectAllFieldsWithcache(t.getClass())).isEmpty()) {
            return null;
        }
        HashMap<String, Object> pkKv = new HashMap<String, Object>();
        StringBuilder fds = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        Set<Object> nullableSets = new HashSet();
        if (t instanceof Model) {
            nullableSets = ((Model)t).getNullableFields();
        }
        try {
            for (Field item : fields) {
                item.setAccessible(true);
                Iterator fieldName = item.getName();
                if (pks.contains(fieldName)) {
                    Object pkValue = item.get(t);
                    String columnKey = map.get(fieldName);
                    pkKv.put(columnKey, pkValue);
                    continue;
                }
                String f = map.get(fieldName);
                Object v = item.get(t);
                if (f != null && v != null) {
                    fds.append(f).append(" = ?,");
                    params.add(v);
                }
                if (f == null) continue;
                boolean nullable = nullableSets.contains(fieldName);
                if (v != null) {
                    fds.append(f).append(" = ?,");
                    params.add(v);
                    continue;
                }
                if (!nullable) continue;
                fds.append(f).append(" = NULL,");
            }
        }
        catch (IllegalAccessException e) {
            throw new ExecutingException(e);
        }
        if (fds.length() <= 0) {
            throw new RuntimeException("update values is empty ~");
        }
        fds.deleteCharAt(fds.length() - 1);
        StringBuilder sb = new StringBuilder();
        sb.append("update ").append(tableName).append(" set ").append((CharSequence)fds);
        if (!pkKv.isEmpty()) {
            String token = " and ";
            sb.append(" where ");
            if (pks.size() == pkKv.size()) {
                for (String k : pks) {
                    String c = map.get(k);
                    sb.append(c).append(" = ?").append(" and ");
                    params.add(pkKv.get(c));
                }
            } else {
                for (Map.Entry entry : pkKv.entrySet()) {
                    sb.append((String)entry.getKey()).append(" = ?").append(" and ");
                    params.add(entry.getValue());
                }
            }
            int totalLen = sb.length();
            int index = sb.length() - " and ".length();
            sb.delete(index, totalLen);
        }
        Object[] objects = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            objects[i] = params.get(i);
        }
        String sql = sb.toString();
        GLog.debug("sql:{} , params:{}", sql, objects);
        return Tuple.apply(sql, objects);
    }

    @Override
    public Tuple buildPaginatorSql(String preSql, int pageNumber, int pageSize) {
        String sqlCount = "select count(1) as totalCount from (" + preSql + ") as temp";
        String sql = preSql + " limit ?, ? ";
        int offset = pageSize * (pageNumber - 1);
        Object[] params = new Object[]{offset, pageSize};
        return Tuple.apply(sqlCount, sql, params);
    }

    @Override
    public Tuple buildDeleteByFieldSQL(List<Tuple> kvList, Class<?> clz) {
        String table = ModelBuilder.getModelTable(clz);
        if (table == null) {
            throw new RuntimeException("\u5bf9\u8c61\u6ca1\u6709Table\u6ce8\u89e3");
        }
        String andToken = " and ";
        StringBuilder sb = new StringBuilder();
        Object[] params = new Object[kvList.size()];
        for (int i = 0; i < kvList.size(); ++i) {
            Tuple kv = kvList.get(i);
            String field = (String)kv.getObject(0);
            Object value = kv.getObject(1);
            sb.append(field).append(" = ?").append(andToken);
            params[i] = value;
        }
        sb.delete(sb.length() - andToken.length(), sb.length());
        String sql = "delete from " + table + " where " + sb.toString();
        return Tuple.apply(sql, params);
    }

    @Override
    public Tuple buildQueryByFieldSQL(List<Tuple> kvList, Class<?> clz) {
        String andToken = " and ";
        String tbl = ModelBuilder.getModelTable(clz);
        StringBuilder sb = new StringBuilder();
        Object[] params = new Object[kvList.size()];
        for (int i = 0; i < kvList.size(); ++i) {
            Tuple kv = kvList.get(i);
            String field = (String)kv.getObject(0);
            Object value = kv.getObject(1);
            sb.append(field).append(" = ?").append(andToken);
            params[i] = value;
        }
        sb.delete(sb.length() - andToken.length(), sb.length());
        String sql = "select * from " + tbl + " where " + sb.toString();
        return Tuple.apply(sql, params);
    }

    @Override
    public String buildSimpleQuery(Class<?> clz) {
        String table = ModelBuilder.getModelTable(clz);
        if (table == null) {
            throw new RuntimeException("\u5bf9\u8c61\u6ca1\u6709Table\u6ce8\u89e3");
        }
        String sql = "select * from " + table;
        return sql;
    }
}

