/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.type;

import cn.sylinx.hbatis.type.ArrayTypeHandler;
import cn.sylinx.hbatis.type.BigDecimalTypeHandler;
import cn.sylinx.hbatis.type.BigIntegerTypeHandler;
import cn.sylinx.hbatis.type.BlobByteObjectArrayTypeHandler;
import cn.sylinx.hbatis.type.BlobInputStreamTypeHandler;
import cn.sylinx.hbatis.type.BlobTypeHandler;
import cn.sylinx.hbatis.type.BooleanTypeHandler;
import cn.sylinx.hbatis.type.ByteArrayTypeHandler;
import cn.sylinx.hbatis.type.ByteObjectArrayTypeHandler;
import cn.sylinx.hbatis.type.ByteTypeHandler;
import cn.sylinx.hbatis.type.CharacterTypeHandler;
import cn.sylinx.hbatis.type.ClobReaderTypeHandler;
import cn.sylinx.hbatis.type.ClobTypeHandler;
import cn.sylinx.hbatis.type.DateOnlyTypeHandler;
import cn.sylinx.hbatis.type.DateTypeHandler;
import cn.sylinx.hbatis.type.DoubleTypeHandler;
import cn.sylinx.hbatis.type.EnumTypeHandler;
import cn.sylinx.hbatis.type.FloatTypeHandler;
import cn.sylinx.hbatis.type.IntegerTypeHandler;
import cn.sylinx.hbatis.type.JdbcType;
import cn.sylinx.hbatis.type.LongTypeHandler;
import cn.sylinx.hbatis.type.MappedJdbcTypes;
import cn.sylinx.hbatis.type.MappedTypes;
import cn.sylinx.hbatis.type.NClobTypeHandler;
import cn.sylinx.hbatis.type.NStringTypeHandler;
import cn.sylinx.hbatis.type.ShortTypeHandler;
import cn.sylinx.hbatis.type.SqlDateTypeHandler;
import cn.sylinx.hbatis.type.SqlTimeTypeHandler;
import cn.sylinx.hbatis.type.SqlTimestampTypeHandler;
import cn.sylinx.hbatis.type.StringTypeHandler;
import cn.sylinx.hbatis.type.TimeOnlyTypeHandler;
import cn.sylinx.hbatis.type.TypeException;
import cn.sylinx.hbatis.type.TypeHandler;
import cn.sylinx.hbatis.type.TypeReference;
import cn.sylinx.hbatis.type.UnknownTypeHandler;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public final class TypeHandlerRegistry {
    private final Map<JdbcType, TypeHandler<?>> JDBC_TYPE_HANDLER_MAP = new EnumMap(JdbcType.class);
    private final Map<Type, Map<JdbcType, TypeHandler<?>>> TYPE_HANDLER_MAP = new HashMap();
    private final TypeHandler<Object> UNKNOWN_TYPE_HANDLER = new UnknownTypeHandler(this);
    private final Map<Class<?>, TypeHandler<?>> ALL_TYPE_HANDLERS_MAP = new HashMap();
    private static TypeHandlerRegistry instance = null;

    public static TypeHandlerRegistry getInstance() {
        if (instance == null) {
            TypeHandlerRegistry.initInstance();
        }
        return instance;
    }

    private static synchronized void initInstance() {
        if (instance == null) {
            instance = new TypeHandlerRegistry();
        }
    }

    private TypeHandlerRegistry() {
        this.register(Boolean.class, new BooleanTypeHandler());
        this.register(Boolean.TYPE, new BooleanTypeHandler());
        this.register(JdbcType.BOOLEAN, new BooleanTypeHandler());
        this.register(JdbcType.BIT, new BooleanTypeHandler());
        this.register(Byte.class, new ByteTypeHandler());
        this.register(Byte.TYPE, new ByteTypeHandler());
        this.register(JdbcType.TINYINT, new ByteTypeHandler());
        this.register(Short.class, new ShortTypeHandler());
        this.register(Short.TYPE, new ShortTypeHandler());
        this.register(JdbcType.SMALLINT, new ShortTypeHandler());
        this.register(Integer.class, new IntegerTypeHandler());
        this.register(Integer.TYPE, new IntegerTypeHandler());
        this.register(JdbcType.INTEGER, new IntegerTypeHandler());
        this.register(Long.class, new LongTypeHandler());
        this.register(Long.TYPE, new LongTypeHandler());
        this.register(Float.class, new FloatTypeHandler());
        this.register(Float.TYPE, new FloatTypeHandler());
        this.register(JdbcType.FLOAT, new FloatTypeHandler());
        this.register(Double.class, new DoubleTypeHandler());
        this.register(Double.TYPE, new DoubleTypeHandler());
        this.register(JdbcType.DOUBLE, new DoubleTypeHandler());
        this.register(Reader.class, new ClobReaderTypeHandler());
        this.register(String.class, new StringTypeHandler());
        this.register(String.class, JdbcType.CHAR, new StringTypeHandler());
        this.register(String.class, JdbcType.CLOB, new ClobTypeHandler());
        this.register(String.class, JdbcType.VARCHAR, new StringTypeHandler());
        this.register(String.class, JdbcType.LONGVARCHAR, new ClobTypeHandler());
        this.register(String.class, JdbcType.NVARCHAR, new NStringTypeHandler());
        this.register(String.class, JdbcType.NCHAR, new NStringTypeHandler());
        this.register(String.class, JdbcType.NCLOB, new NClobTypeHandler());
        this.register(JdbcType.CHAR, new StringTypeHandler());
        this.register(JdbcType.VARCHAR, new StringTypeHandler());
        this.register(JdbcType.CLOB, new ClobTypeHandler());
        this.register(JdbcType.LONGVARCHAR, new ClobTypeHandler());
        this.register(JdbcType.NVARCHAR, new NStringTypeHandler());
        this.register(JdbcType.NCHAR, new NStringTypeHandler());
        this.register(JdbcType.NCLOB, new NClobTypeHandler());
        this.register(Object.class, JdbcType.ARRAY, new ArrayTypeHandler());
        this.register(JdbcType.ARRAY, new ArrayTypeHandler());
        this.register(BigInteger.class, new BigIntegerTypeHandler());
        this.register(JdbcType.BIGINT, new LongTypeHandler());
        this.register(BigDecimal.class, new BigDecimalTypeHandler());
        this.register(JdbcType.REAL, new BigDecimalTypeHandler());
        this.register(JdbcType.DECIMAL, new BigDecimalTypeHandler());
        this.register(JdbcType.NUMERIC, new BigDecimalTypeHandler());
        this.register(InputStream.class, new BlobInputStreamTypeHandler());
        this.register(Byte[].class, new ByteObjectArrayTypeHandler());
        this.register(Byte[].class, JdbcType.BLOB, new BlobByteObjectArrayTypeHandler());
        this.register(Byte[].class, JdbcType.LONGVARBINARY, new BlobByteObjectArrayTypeHandler());
        this.register(byte[].class, new ByteArrayTypeHandler());
        this.register(byte[].class, JdbcType.BLOB, new BlobTypeHandler());
        this.register(byte[].class, JdbcType.LONGVARBINARY, new BlobTypeHandler());
        this.register(JdbcType.LONGVARBINARY, new BlobTypeHandler());
        this.register(JdbcType.BLOB, new BlobTypeHandler());
        this.register(Object.class, this.UNKNOWN_TYPE_HANDLER);
        this.register(Object.class, JdbcType.OTHER, this.UNKNOWN_TYPE_HANDLER);
        this.register(JdbcType.OTHER, this.UNKNOWN_TYPE_HANDLER);
        this.register(java.util.Date.class, new DateTypeHandler());
        this.register(java.util.Date.class, JdbcType.DATE, new DateOnlyTypeHandler());
        this.register(java.util.Date.class, JdbcType.TIME, new TimeOnlyTypeHandler());
        this.register(JdbcType.TIMESTAMP, new DateTypeHandler());
        this.register(JdbcType.DATE, new DateOnlyTypeHandler());
        this.register(JdbcType.TIME, new TimeOnlyTypeHandler());
        this.register(Date.class, new SqlDateTypeHandler());
        this.register(Time.class, new SqlTimeTypeHandler());
        this.register(Timestamp.class, new SqlTimestampTypeHandler());
        this.register(Character.class, new CharacterTypeHandler());
        this.register(Character.TYPE, new CharacterTypeHandler());
    }

    public boolean hasTypeHandler(Class<?> javaType) {
        return this.hasTypeHandler(javaType, null);
    }

    public boolean hasTypeHandler(TypeReference<?> javaTypeReference) {
        return this.hasTypeHandler(javaTypeReference, null);
    }

    public boolean hasTypeHandler(Class<?> javaType, JdbcType jdbcType) {
        return javaType != null && this.getTypeHandler((Type)javaType, jdbcType) != null;
    }

    public boolean hasTypeHandler(TypeReference<?> javaTypeReference, JdbcType jdbcType) {
        return javaTypeReference != null && this.getTypeHandler(javaTypeReference, jdbcType) != null;
    }

    public TypeHandler<?> getMappingTypeHandler(Class<? extends TypeHandler<?>> handlerType) {
        return this.ALL_TYPE_HANDLERS_MAP.get(handlerType);
    }

    public <T> TypeHandler<T> getTypeHandler(Class<T> type) {
        return this.getTypeHandler((Type)type, null);
    }

    public <T> TypeHandler<T> getTypeHandler(TypeReference<T> javaTypeReference) {
        return this.getTypeHandler(javaTypeReference, null);
    }

    public TypeHandler<?> getTypeHandler(JdbcType jdbcType) {
        return this.JDBC_TYPE_HANDLER_MAP.get((Object)jdbcType);
    }

    public <T> TypeHandler<T> getTypeHandler(Class<T> type, JdbcType jdbcType) {
        return this.getTypeHandler((Type)type, jdbcType);
    }

    public <T> TypeHandler<T> getTypeHandler(TypeReference<T> javaTypeReference, JdbcType jdbcType) {
        return this.getTypeHandler(javaTypeReference.getRawType(), jdbcType);
    }

    private <T> TypeHandler<T> getTypeHandler(Type type, JdbcType jdbcType) {
        Map<JdbcType, TypeHandler<?>> jdbcHandlerMap = this.TYPE_HANDLER_MAP.get(type);
        TypeHandler<?> handler = null;
        if (jdbcHandlerMap != null && (handler = jdbcHandlerMap.get((Object)jdbcType)) == null) {
            handler = jdbcHandlerMap.get(null);
        }
        if (handler == null && type != null && type instanceof Class && Enum.class.isAssignableFrom((Class)type)) {
            handler = new EnumTypeHandler((Class)type);
        }
        return handler;
    }

    public TypeHandler<Object> getUnknownTypeHandler() {
        return this.UNKNOWN_TYPE_HANDLER;
    }

    public void register(JdbcType jdbcType, TypeHandler<?> handler) {
        this.JDBC_TYPE_HANDLER_MAP.put(jdbcType, handler);
    }

    public <T> void register(TypeHandler<T> typeHandler) {
        boolean mappedTypeFound = false;
        MappedTypes mappedTypes = typeHandler.getClass().getAnnotation(MappedTypes.class);
        if (mappedTypes != null) {
            for (Class<?> handledType : mappedTypes.value()) {
                this.register((Type)handledType, (TypeHandler<? extends T>)typeHandler);
                mappedTypeFound = true;
            }
        }
        if (!mappedTypeFound && typeHandler instanceof TypeReference) {
            try {
                TypeReference typeReference = (TypeReference)((Object)typeHandler);
                this.register(typeReference.getRawType(), typeHandler);
                mappedTypeFound = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!mappedTypeFound) {
            this.register((Class)null, typeHandler);
        }
    }

    public <T> void register(Class<T> javaType, TypeHandler<? extends T> typeHandler) {
        this.register((Type)javaType, typeHandler);
    }

    private <T> void register(Type javaType, TypeHandler<? extends T> typeHandler) {
        MappedJdbcTypes mappedJdbcTypes = typeHandler.getClass().getAnnotation(MappedJdbcTypes.class);
        if (mappedJdbcTypes != null) {
            for (JdbcType handledJdbcType : mappedJdbcTypes.value()) {
                this.register(javaType, handledJdbcType, typeHandler);
            }
            if (mappedJdbcTypes.includeNullJdbcType()) {
                this.register(javaType, null, typeHandler);
            }
        } else {
            this.register(javaType, null, typeHandler);
        }
    }

    public <T> void register(TypeReference<T> javaTypeReference, TypeHandler<? extends T> handler) {
        this.register(javaTypeReference.getRawType(), handler);
    }

    public <T> void register(Class<T> type, JdbcType jdbcType, TypeHandler<? extends T> handler) {
        this.register((Type)type, jdbcType, (TypeHandler<?>)handler);
    }

    private void register(Type javaType, JdbcType jdbcType, TypeHandler<?> handler) {
        if (javaType != null) {
            Map<JdbcType, TypeHandler<?>> map = this.TYPE_HANDLER_MAP.get(javaType);
            if (map == null) {
                map = new HashMap();
                this.TYPE_HANDLER_MAP.put(javaType, map);
            }
            map.put(jdbcType, handler);
        }
        this.ALL_TYPE_HANDLERS_MAP.put(handler.getClass(), handler);
    }

    public void register(Class<?> typeHandlerClass) {
        boolean mappedTypeFound = false;
        MappedTypes mappedTypes = typeHandlerClass.getAnnotation(MappedTypes.class);
        if (mappedTypes != null) {
            for (Class<?> javaTypeClass : mappedTypes.value()) {
                this.register(javaTypeClass, typeHandlerClass);
                mappedTypeFound = true;
            }
        }
        if (!mappedTypeFound) {
            this.register(this.getInstance(null, typeHandlerClass));
        }
    }

    public void register(Class<?> javaTypeClass, Class<?> typeHandlerClass) {
        this.register((Type)javaTypeClass, (TypeHandler)this.getInstance(javaTypeClass, typeHandlerClass));
    }

    public void register(Class<?> javaTypeClass, JdbcType jdbcType, Class<?> typeHandlerClass) {
        this.register((Type)javaTypeClass, jdbcType, this.getInstance(javaTypeClass, typeHandlerClass));
    }

    private <T> TypeHandler<T> getInstance(Class<?> javaTypeClass, Class<?> typeHandlerClass) {
        if (javaTypeClass != null) {
            try {
                Constructor<?> c = typeHandlerClass.getConstructor(Class.class);
                return (TypeHandler)c.newInstance(javaTypeClass);
            }
            catch (NoSuchMethodException c) {
            }
            catch (Exception e) {
                throw new TypeException("Failed invoking constructor for handler " + typeHandlerClass, e);
            }
        }
        try {
            Constructor<?> c = typeHandlerClass.getConstructor(new Class[0]);
            return (TypeHandler)c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new TypeException("Unable to find a usable constructor for " + typeHandlerClass, e);
        }
    }

    public Collection<TypeHandler<?>> getTypeHandlers() {
        return Collections.unmodifiableCollection(this.ALL_TYPE_HANDLERS_MAP.values());
    }
}

