/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.plugin.datasource;

import cn.sylinx.hbatis.db.dialect.DbType;
import cn.sylinx.hbatis.ds.JdbcResource;
import cn.sylinx.hbatis.ds.JdbcResourceWrapper;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.plugin.JdbcResourcePlugin;
import javax.sql.DataSource;

public class DataSourcePlugin
extends JdbcResourcePlugin {
    private String jdbcResourceName;
    private DataSource dataSource;
    private String dbType = DbType.MYSQL.getValue();

    @Override
    public JdbcResourceWrapper createJdbcResourceWrapper(Object ... objects) {
        boolean defaultJdbcResource = false;
        if (StrKit.isBlank(this.jdbcResourceName)) {
            this.jdbcResourceName = "hbatisDefaultJdbcResource";
            defaultJdbcResource = true;
        }
        JdbcResourceWrapper jrw = new JdbcResourceWrapper();
        jrw.setDefaultResource(defaultJdbcResource);
        jrw.setJdbcResource(new JdbcResource(this.jdbcResourceName, this.dataSource, DbType.getDbType(this.dbType)));
        jrw.setResourceName(this.jdbcResourceName);
        return jrw;
    }

    public DataSourcePlugin setJdbcResourceName(String jdbcResourceName) {
        this.jdbcResourceName = jdbcResourceName;
        return this;
    }

    public DataSourcePlugin setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public DataSourcePlugin setDbType(String dbType) {
        this.dbType = dbType;
        return this;
    }
}

