/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.db.dialect;

import cn.sylinx.hbatis.db.dialect.DbType;
import cn.sylinx.hbatis.db.dialect.DefaultDialect;
import cn.sylinx.hbatis.kit.Tuple;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class OracleDialect
extends DefaultDialect {
    @Override
    public void setParameters(PreparedStatement pst, Object ... params) throws SQLException {
        int size = params.length;
        for (int i = 0; i < size; ++i) {
            try {
                Object value = params[i];
                if (value instanceof java.sql.Date) {
                    pst.setDate(i + 1, (java.sql.Date)value);
                    continue;
                }
                if (value instanceof Timestamp) {
                    pst.setTimestamp(i + 1, (Timestamp)value);
                    continue;
                }
                if (value instanceof Date) {
                    Date preValue = (Date)value;
                    java.sql.Date d = new java.sql.Date(preValue.getTime());
                    pst.setDate(i + 1, d);
                    continue;
                }
                pst.setObject(i + 1, value);
                continue;
            }
            catch (SQLException e) {
                System.out.println(params[i].getClass() + ":" + params[i]);
                throw e;
            }
        }
    }

    @Override
    public DbType getDbType() {
        return DbType.ORACLE;
    }

    @Override
    public Tuple getPaginatorSql(String preSql, int pageNumber, int pageSize) {
        String sqlCount = "SELECT count(1) as totalCount from (" + preSql + ")";
        int offsetBegin = pageSize * (pageNumber - 1);
        int offsetEnd = offsetBegin + pageSize;
        String sqlLimit = "SELECT /*+ FIRST_ROWS */ * FROM (SELECT A.*, ROWNUM RN FROM (" + preSql + ") A  WHERE ROWNUM <= ?) WHERE RN > ? ";
        Object[] params = new Object[]{offsetEnd, offsetBegin};
        return Tuple.apply(sqlCount, sqlLimit, params);
    }
}

