/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.db.common;

import cn.sylinx.hbatis.db.cache.CacheKeyGenerator;
import cn.sylinx.hbatis.db.cache.CacheQuery;
import cn.sylinx.hbatis.db.cache.IDataLoader;
import cn.sylinx.hbatis.db.common.DbPro;
import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.ehcache.CacheKit;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;

public class DefaultCacheQuery
implements CacheQuery {
    private final DbPro dbPro;

    public DefaultCacheQuery(DbPro dbPro) {
        this.dbPro = dbPro;
    }

    public String getSqlMD5(String key) {
        if (StrKit.isEmpty(key)) {
            return "";
        }
        MessageDigest digest = null;
        byte[] buffer = key.getBytes(Charset.defaultCharset());
        try {
            digest = MessageDigest.getInstance("MD5");
            digest.update(buffer);
        }
        catch (Exception e) {
            GLog.error("md5 encode error", e);
        }
        BigInteger bigInt = new BigInteger(1, digest.digest());
        return bigInt.toString(16);
    }

    @Override
    public Record queryFirstRecord(final String sql, final Object ... params) {
        if (!CacheKit.isInited()) {
            throw new RuntimeException("\u7f13\u5b58\u6ca1\u6709\u914d\u7f6e");
        }
        Object key = CacheKeyGenerator.generateCacheKey(this.dbPro.getDataSourceName() + "Q1", sql, params);
        String cacheKey = this.getSqlMD5(String.valueOf(key));
        return (Record)CacheKit.get("hbatis_default_cache", (Object)cacheKey, new IDataLoader<Record>(){

            @Override
            public Record load() {
                return DefaultCacheQuery.this.dbPro.queryFirstRecord(sql, params);
            }
        });
    }

    @Override
    public List<Record> queryRecords(final String sql, final Object ... params) {
        if (!CacheKit.isInited()) {
            throw new RuntimeException("\u7f13\u5b58\u6ca1\u6709\u914d\u7f6e");
        }
        Object key = CacheKeyGenerator.generateCacheKey(this.dbPro.getDataSourceName() + "Q2", sql, params);
        String cacheKey = this.getSqlMD5(String.valueOf(key));
        return (List)CacheKit.get("hbatis_default_cache", (Object)cacheKey, new IDataLoader<List<Record>>(){

            @Override
            public List<Record> load() {
                return DefaultCacheQuery.this.dbPro.queryRecords(sql, params);
            }
        });
    }

    @Override
    public List<Object[]> query(final String sql, final Object ... params) {
        if (!CacheKit.isInited()) {
            throw new RuntimeException("\u7f13\u5b58\u6ca1\u6709\u914d\u7f6e");
        }
        Object key = CacheKeyGenerator.generateCacheKey(this.dbPro.getDataSourceName() + "Q3", sql, params);
        String cacheKey = this.getSqlMD5(String.valueOf(key));
        return (List)CacheKit.get("hbatis_default_cache", (Object)cacheKey, new IDataLoader<List<Object[]>>(){

            @Override
            public List<Object[]> load() {
                return DefaultCacheQuery.this.dbPro.query(sql, params);
            }
        });
    }

    @Override
    public List<Map<String, Object>> queryMap(final String sql, final Object ... params) {
        if (!CacheKit.isInited()) {
            throw new RuntimeException("\u7f13\u5b58\u6ca1\u6709\u914d\u7f6e");
        }
        Object key = CacheKeyGenerator.generateCacheKey(this.dbPro.getDataSourceName() + "Q4", sql, params);
        String cacheKey = this.getSqlMD5(String.valueOf(key));
        return (List)CacheKit.get("hbatis_default_cache", (Object)cacheKey, new IDataLoader<List<Map<String, Object>>>(){

            @Override
            public List<Map<String, Object>> load() {
                return DefaultCacheQuery.this.dbPro.queryMap(sql, params);
            }
        });
    }

    @Override
    public Object[] queryFirst(final String sql, final Object ... params) {
        if (!CacheKit.isInited()) {
            throw new RuntimeException("\u7f13\u5b58\u6ca1\u6709\u914d\u7f6e");
        }
        Object key = CacheKeyGenerator.generateCacheKey(this.dbPro.getDataSourceName() + "Q5", sql, params);
        String cacheKey = this.getSqlMD5(String.valueOf(key));
        return (Object[])CacheKit.get("hbatis_default_cache", (Object)cacheKey, new IDataLoader<Object[]>(){

            @Override
            public Object[] load() {
                return DefaultCacheQuery.this.dbPro.queryFirst(sql, params);
            }
        });
    }

    @Override
    public Map<String, Object> queryFirstMap(final String sql, final Object ... params) {
        if (!CacheKit.isInited()) {
            throw new RuntimeException("\u7f13\u5b58\u6ca1\u6709\u914d\u7f6e");
        }
        Object key = CacheKeyGenerator.generateCacheKey(this.dbPro.getDataSourceName() + "Q6", sql, params);
        String cacheKey = this.getSqlMD5(String.valueOf(key));
        return (Map)CacheKit.get("hbatis_default_cache", (Object)cacheKey, new IDataLoader<Map<String, Object>>(){

            @Override
            public Map<String, Object> load() {
                return DefaultCacheQuery.this.dbPro.queryFirstMap(sql, params);
            }
        });
    }

    @Override
    public <T> List<T> query(final String sql, final QueryMapper<T> mapper, final Object ... params) {
        if (!CacheKit.isInited()) {
            throw new RuntimeException("\u7f13\u5b58\u6ca1\u6709\u914d\u7f6e");
        }
        Object key = CacheKeyGenerator.generateCacheKey(this.dbPro.getDataSourceName() + "Q7", sql, params);
        String cacheKey = this.getSqlMD5(String.valueOf(key));
        return (List)CacheKit.get("hbatis_default_cache", (Object)cacheKey, new IDataLoader<List<T>>(){

            @Override
            public List<T> load() {
                return DefaultCacheQuery.this.dbPro.query(sql, mapper, params);
            }
        });
    }

    @Override
    public <T> T queryFirst(final String sql, final QueryMapper<T> mapper, final Object ... params) {
        if (!CacheKit.isInited()) {
            throw new RuntimeException("\u7f13\u5b58\u6ca1\u6709\u914d\u7f6e");
        }
        Object key = CacheKeyGenerator.generateCacheKey(this.dbPro.getDataSourceName() + "Q8", sql, params);
        String cacheKey = this.getSqlMD5(String.valueOf(key));
        return CacheKit.get("hbatis_default_cache", (Object)cacheKey, new IDataLoader<T>(){

            @Override
            public T load() {
                return DefaultCacheQuery.this.dbPro.queryFirst(sql, mapper, params);
            }
        });
    }
}

