/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.db.common;

import cn.sylinx.hbatis.db.common.ITransaction;
import cn.sylinx.hbatis.db.common.Record;
import cn.sylinx.hbatis.db.dialect.Dialect;
import cn.sylinx.hbatis.db.dialect.DialectFatory;
import cn.sylinx.hbatis.db.mapper.DeleteMapper;
import cn.sylinx.hbatis.db.mapper.InsertMapper;
import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.db.mapper.QueryMapper;
import cn.sylinx.hbatis.db.mapper.UpdateMapper;
import cn.sylinx.hbatis.ds.JdbcBlock;
import cn.sylinx.hbatis.ds.JdbcResource;
import cn.sylinx.hbatis.ds.JdbcResourceManager;
import cn.sylinx.hbatis.ds.ResourceHelper;
import cn.sylinx.hbatis.exception.NestedTransactionException;
import cn.sylinx.hbatis.kit.DbKit;
import cn.sylinx.hbatis.kit.Tuple;
import cn.sylinx.hbatis.log.GLog;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DbPro {
    public static final int DEFAULT_BATCH_SIZE = 500;
    private final JdbcResource jdbcResource;
    private final String dataSourceName;
    private final Dialect dialect;

    DbPro(String jdbcResourceName) {
        this.jdbcResource = JdbcResourceManager.get().get(jdbcResourceName);
        if (this.jdbcResource == null) {
            throw new IllegalArgumentException("jdbc resource not found by jdbcResourceName: " + jdbcResourceName);
        }
        this.dataSourceName = this.jdbcResource.getDataSourceName();
        this.dialect = DialectFatory.get().createDialect(this.jdbcResource.getDbType());
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public static DbPro use(String jdbcResourceName) {
        DbPro result = new DbPro(jdbcResourceName);
        return result;
    }

    public static DbPro use() {
        return new DbPro("hbatisDefaultJdbcResource");
    }

    public int[] batch(List<String> sql) {
        return this.batch(sql, 500);
    }

    public int[] batch(String sql, Object[][] params) {
        return this.batch(sql, params, 500);
    }

    public int[] batch(final String sql, final Object[][] params, final int batchSize) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<int[]>(){

            private int[] batchInner(Connection conn, String sql2, Object[][] params2, int batchSize2) throws SQLException {
                if (params2 == null || params2.length == 0) {
                    throw new IllegalArgumentException("The paras array length must more than 0.");
                }
                if (batchSize2 < 1) {
                    throw new IllegalArgumentException("The batchSize must more than 0.");
                }
                int counter = 0;
                int pointer = 0;
                int[] result = new int[params2.length];
                PreparedStatement pst = conn.prepareStatement(sql2);
                for (int i = 0; i < params2.length; ++i) {
                    DbPro.this.dialect.setParameters(pst, params2[i]);
                    pst.addBatch();
                    if (++counter < batchSize2) continue;
                    counter = 0;
                    int[] r = pst.executeBatch();
                    conn.commit();
                    for (int k = 0; k < r.length; ++k) {
                        result[pointer++] = r[k];
                    }
                }
                int[] r = pst.executeBatch();
                conn.commit();
                for (int k = 0; k < r.length; ++k) {
                    result[pointer++] = r[k];
                }
                DbKit.closeQuietly(pst);
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] applyBlock(Connection conn) throws SQLException {
                Boolean autoCommit = null;
                try {
                    autoCommit = conn.getAutoCommit();
                    conn.setAutoCommit(false);
                    int[] nArray = this.batchInner(conn, sql, params, batchSize);
                    return nArray;
                }
                finally {
                    if (autoCommit != null) {
                        conn.setAutoCommit(autoCommit);
                    }
                }
            }
        });
    }

    public int[] batch(final List<String> sqlList, final int batchSize) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<int[]>(){

            private int[] batchInner(Connection conn, List<String> sqlList2, int batchSize2) throws SQLException {
                if (sqlList2 == null || sqlList2.size() == 0) {
                    throw new IllegalArgumentException("The sqlList length must more than 0.");
                }
                if (batchSize2 < 1) {
                    throw new IllegalArgumentException("The batchSize must more than 0.");
                }
                int counter = 0;
                int pointer = 0;
                int size = sqlList2.size();
                int[] result = new int[size];
                Statement st = conn.createStatement();
                for (int i = 0; i < size; ++i) {
                    st.addBatch(sqlList2.get(i));
                    if (++counter < batchSize2) continue;
                    counter = 0;
                    int[] r = st.executeBatch();
                    conn.commit();
                    for (int k = 0; k < r.length; ++k) {
                        result[pointer++] = r[k];
                    }
                }
                int[] r = st.executeBatch();
                conn.commit();
                for (int k = 0; k < r.length; ++k) {
                    result[pointer++] = r[k];
                }
                DbKit.closeQuietly(st);
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] applyBlock(Connection conn) throws SQLException {
                Boolean autoCommit = null;
                try {
                    autoCommit = conn.getAutoCommit();
                    conn.setAutoCommit(false);
                    int[] nArray = this.batchInner(conn, sqlList, batchSize);
                    return nArray;
                }
                finally {
                    if (autoCommit != null) {
                        conn.setAutoCommit(autoCommit);
                    }
                }
            }
        });
    }

    public boolean transaction(final ITransaction transaction) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean applyBlock(Connection conn) throws SQLException {
                Connection transCon = DbPro.this.jdbcResource.getTransactionConnection();
                if (transCon != null) {
                    boolean result = transaction.run();
                    if (result) {
                        return true;
                    }
                    throw new NestedTransactionException("Notice the outer transaction that the nested transaction return false");
                }
                Boolean autoCommit = null;
                try {
                    autoCommit = conn.getAutoCommit();
                    conn.setTransactionIsolation(2);
                    conn.setAutoCommit(false);
                    DbPro.this.jdbcResource.setTransactionConnection(conn);
                    boolean result = transaction.run();
                    if (result) {
                        conn.commit();
                    } else {
                        conn.rollback();
                    }
                    Boolean bl = result;
                    return bl;
                }
                catch (Throwable t) {
                    GLog.error("transaction error :", t);
                    conn.rollback();
                }
                finally {
                    conn.setAutoCommit(autoCommit);
                    DbPro.this.jdbcResource.removeTransactionConnection();
                }
                return false;
            }
        });
    }

    public <T> int delete(T t) {
        if (t == null) {
            return 0;
        }
        DeleteMapper<T> mapper = ModelBuilder.buildDeleteMapper(t);
        return this.delete(t, mapper);
    }

    public <T> int delete(T t, DeleteMapper<T> mapper) {
        if (t == null || mapper == null) {
            return 0;
        }
        Tuple tuple = null;
        try {
            tuple = ModelBuilder.buildDeleteSQL(t, mapper);
        }
        catch (Exception e) {
            GLog.error("ModelBuilder.buildDeleteSQL(t, mapper) error: ", e);
        }
        if (tuple == null) {
            return 0;
        }
        String updateSql = (String)tuple.get(0);
        Object[] params = (Object[])tuple.get(1);
        return this.update(updateSql, params);
    }

    public <T> Object save(T t) {
        if (t == null) {
            return 0;
        }
        InsertMapper<T> mapper = ModelBuilder.buildInserMapper(t);
        return this.save(t, mapper);
    }

    public <T> Object save(T t, InsertMapper<T> mapper) {
        if (t == null || mapper == null) {
            return 0;
        }
        Tuple tuple = null;
        try {
            tuple = ModelBuilder.buildInsertSQL(t, mapper);
        }
        catch (Exception e) {
            GLog.error("ModelBuilder.buildInsertSQL(t, mapper) error: ", e);
        }
        if (tuple == null) {
            return 0;
        }
        String updateSql = (String)tuple.get(0);
        Object[] params = (Object[])tuple.get(1);
        return this.save(updateSql, params);
    }

    public <T> int update(T t) {
        if (t == null) {
            throw new IllegalArgumentException("\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4");
        }
        UpdateMapper<T> mapper = ModelBuilder.buildUpdateMapper(t);
        return this.update(t, mapper);
    }

    public <T> int update(T t, UpdateMapper<T> mapper) {
        if (t == null || mapper == null) {
            throw new RuntimeException("\u66f4\u65b0\u5bf9\u8c61\u4e3a\u7a7a");
        }
        Tuple tuple = null;
        try {
            tuple = ModelBuilder.buildUpdateSQL(t, mapper);
        }
        catch (Exception e) {
            GLog.error("ModelBuilder.buildUpdateSQL(t, mapper) error: ", e);
            throw new RuntimeException(e);
        }
        if (tuple == null) {
            return 0;
        }
        String updateSql = (String)tuple.get(0);
        Object[] params = (Object[])tuple.get(1);
        return this.update(updateSql, params);
    }

    public boolean execute(final String exeSql, final Object ... params) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<Boolean>(){

            @Override
            public Boolean applyBlock(Connection conn) throws SQLException {
                PreparedStatement pst = conn.prepareStatement(exeSql);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                boolean bl = pst.execute();
                DbKit.closeQuietly(pst);
                return bl;
            }
        });
    }

    public boolean executeLargeUpdate(final List<String> exeSqlList) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<Boolean>(){

            @Override
            public Boolean applyBlock(Connection conn) {
                try {
                    Statement st = conn.createStatement();
                    for (String sql : exeSqlList) {
                        st.addBatch(sql);
                    }
                    int[] rst = st.executeBatch();
                    GLog.info("executeLargeUpdate rst:{}", new Object[]{rst});
                    DbKit.closeQuietly(st);
                }
                catch (Exception e) {
                    GLog.error("executeLargeUpdate error ", e);
                    return false;
                }
                return true;
            }
        });
    }

    public int update(final String updateSql, final Object ... params) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<Integer>(){

            @Override
            public Integer applyBlock(Connection conn) throws SQLException {
                int result;
                PreparedStatement pst = conn.prepareStatement(updateSql);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                if ((result = pst.executeUpdate()) < 1) {
                    GLog.info("0 rows updated, sql:" + updateSql, new Object[0]);
                }
                DbKit.closeQuietly(pst);
                return result;
            }
        });
    }

    public Object save(String insertSql, Object ... params) {
        return this.updateWithReturnPk(insertSql, params);
    }

    public Object updateWithReturnPk(final String updateSql, final Object ... params) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<Object>(){

            @Override
            public Object applyBlock(Connection conn) throws SQLException {
                ResultSet rs;
                int result;
                PreparedStatement pst = conn.prepareStatement(updateSql, 1);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                if ((result = pst.executeUpdate()) < 1) {
                    GLog.error("update error, sql:" + updateSql, new Object[0]);
                }
                Object pk = (rs = pst.getGeneratedKeys()).next() ? rs.getObject(1) : null;
                DbKit.closeQuietly(rs, pst);
                return pk;
            }
        });
    }

    public Map<String, Object> queryFirstMap(final String sql, final Object ... params) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<Map<String, Object>>(){

            @Override
            public Map<String, Object> applyBlock(Connection conn) throws SQLException {
                PreparedStatement pst = conn.prepareStatement(sql);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                ResultSet rs = pst.executeQuery();
                ResultSetMetaData rsmetas = rs.getMetaData();
                int columnCount = rsmetas.getColumnCount();
                HashMap<String, Object> result = new HashMap<String, Object>();
                if (rs.next()) {
                    int len = columnCount + 1;
                    for (int i = 1; i < len; ++i) {
                        result.put(rsmetas.getColumnLabel(i).toUpperCase(), rs.getObject(i));
                    }
                }
                DbKit.closeQuietly(rs, pst);
                return result;
            }
        });
    }

    public Object[] queryFirst(final String sql, final Object ... params) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<Object[]>(){

            @Override
            public Object[] applyBlock(Connection conn) throws SQLException {
                PreparedStatement pst = conn.prepareStatement(sql);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                ResultSet rs = pst.executeQuery();
                ResultSetMetaData rsmetas = rs.getMetaData();
                int columnCount = rsmetas.getColumnCount();
                Object[] result = null;
                if (rs.next()) {
                    result = new Object[columnCount];
                    int len = columnCount + 1;
                    for (int i = 1; i < len; ++i) {
                        result[i - 1] = rs.getObject(i);
                    }
                }
                DbKit.closeQuietly(rs, pst);
                return result;
            }
        });
    }

    public Record queryFirstRecord(final String sql, final Object ... params) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<Record>(){

            @Override
            public Record applyBlock(Connection conn) throws SQLException {
                PreparedStatement pst = conn.prepareStatement(sql);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                ResultSet rs = pst.executeQuery();
                ResultSetMetaData rsmetas = rs.getMetaData();
                int columnCount = rsmetas.getColumnCount();
                Record tmp = null;
                if (rs.next()) {
                    tmp = new Record();
                    int len = columnCount + 1;
                    for (int i = 1; i < len; ++i) {
                        tmp.put(rsmetas.getColumnLabel(i), i, rs.getObject(i));
                    }
                }
                DbKit.closeQuietly(rs, pst);
                return tmp;
            }
        });
    }

    public List<Record> queryRecords(final String sql, final Object ... params) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<List<Record>>(){

            @Override
            public List<Record> applyBlock(Connection conn) throws SQLException {
                ArrayList<Record> result = new ArrayList<Record>();
                PreparedStatement pst = conn.prepareStatement(sql);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                ResultSet rs = pst.executeQuery();
                ResultSetMetaData rsmetas = rs.getMetaData();
                int columnCount = rsmetas.getColumnCount();
                Record tmp = null;
                while (rs.next()) {
                    tmp = new Record();
                    int len = columnCount + 1;
                    for (int i = 1; i < len; ++i) {
                        tmp.put(rsmetas.getColumnLabel(i), i, rs.getObject(i));
                    }
                    result.add(tmp);
                }
                DbKit.closeQuietly(rs, pst);
                return result;
            }
        });
    }

    public List<Map<String, Object>> queryMap(final String sql, final Object ... params) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<List<Map<String, Object>>>(){

            @Override
            public List<Map<String, Object>> applyBlock(Connection conn) throws SQLException {
                ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
                PreparedStatement pst = conn.prepareStatement(sql);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                ResultSet rs = pst.executeQuery();
                ResultSetMetaData rsmetas = rs.getMetaData();
                int columnCount = rsmetas.getColumnCount();
                HashMap<String, Object> tmp = null;
                while (rs.next()) {
                    tmp = new HashMap<String, Object>();
                    int len = columnCount + 1;
                    for (int i = 1; i < len; ++i) {
                        tmp.put(rsmetas.getColumnLabel(i).toUpperCase(), rs.getObject(i));
                    }
                    result.add(tmp);
                }
                DbKit.closeQuietly(rs, pst);
                return result;
            }
        });
    }

    public List<Object[]> query(final String sql, final Object ... params) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<List<Object[]>>(){

            @Override
            public List<Object[]> applyBlock(Connection conn) throws SQLException {
                ArrayList<Object[]> result = new ArrayList<Object[]>();
                PreparedStatement pst = conn.prepareStatement(sql);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                ResultSet rs = pst.executeQuery();
                ResultSetMetaData rsmetas = rs.getMetaData();
                int columnCount = rsmetas.getColumnCount();
                while (rs.next()) {
                    Object[] row = new Object[columnCount];
                    int len = columnCount + 1;
                    for (int i = 1; i < len; ++i) {
                        row[i - 1] = rs.getObject(i);
                    }
                    result.add(row);
                }
                DbKit.closeQuietly(rs, pst);
                return result;
            }
        });
    }

    public <T> T queryFirst(final String sql, final QueryMapper<T> mapper, final Object ... params) {
        if (mapper == null) {
            return (T)this.queryFirst(sql, params);
        }
        return (T)ResourceHelper.using(this.jdbcResource, new JdbcBlock<T>(){

            @Override
            public T applyBlock(Connection conn) throws SQLException {
                PreparedStatement pst = conn.prepareStatement(sql);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                ResultSet rs = pst.executeQuery();
                Object result = null;
                try {
                    result = ModelBuilder.buildFirstQueryModel(rs, mapper);
                }
                catch (InstantiationException e) {
                    GLog.error("buildFirstQueryModel InstantiationException occur:", e);
                }
                catch (IllegalAccessException e) {
                    GLog.error("buildFirstQueryModel IllegalAccessException occur:", e);
                }
                DbKit.closeQuietly(rs, pst);
                return result;
            }
        });
    }

    public <T> List<T> query(final String sql, final QueryMapper<T> mapper, final Object ... params) {
        if (mapper == null) {
            return this.query(sql, params);
        }
        return (List)ResourceHelper.using(this.jdbcResource, new JdbcBlock<List<T>>(){

            @Override
            public List<T> applyBlock(Connection conn) throws SQLException {
                PreparedStatement pst = conn.prepareStatement(sql);
                if (params != null) {
                    DbPro.this.dialect.setParameters(pst, params);
                }
                ResultSet rs = pst.executeQuery();
                List result = null;
                try {
                    result = ModelBuilder.buildQueryModel(rs, mapper);
                }
                catch (InstantiationException e) {
                    GLog.error("buildQueryModel InstantiationException occur ", e);
                }
                catch (IllegalAccessException e) {
                    GLog.error("buildQueryModel IllegalAccessException occur ", e);
                }
                DbKit.closeQuietly(rs, pst);
                return result;
            }
        });
    }

    public boolean existTable(final String schema, final String table) {
        return ResourceHelper.using(this.jdbcResource, new JdbcBlock<Boolean>(){

            @Override
            public Boolean applyBlock(Connection conn) throws SQLException {
                boolean result = false;
                DatabaseMetaData dm = conn.getMetaData();
                ResultSet rs = dm.getTables(null, schema, table, new String[]{"TABLE"});
                result = rs.next();
                DbKit.closeQuietly(rs);
                return result;
            }
        });
    }
}

