/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.plugin.model;

import cn.sylinx.hbatis.db.mapper.MappingFileManager;
import cn.sylinx.hbatis.db.mapper.ModelBuilder;
import cn.sylinx.hbatis.db.mapper.anno.AttributeColumnMapping;
import cn.sylinx.hbatis.db.mapper.anno.PrimaryKey;
import cn.sylinx.hbatis.db.mapper.anno.Table;
import cn.sylinx.hbatis.kit.StrKit;
import cn.sylinx.hbatis.log.GLog;
import cn.sylinx.hbatis.plugin.model.ModelFabric;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;

public enum ModelCacheManager {
    ME;

    private Map<String, ModelFabric> cached = new ConcurrentHashMap<String, ModelFabric>();

    public static ModelCacheManager get() {
        return ME;
    }

    public ModelFabric getModelFabric(Class<?> clz) {
        String clzStr = clz.getName();
        return this.getModelFabric(clzStr);
    }

    public ModelFabric getModelFabric(String clzStr) {
        ModelFabric mf = this.cached.get(clzStr);
        if (mf == null) {
            try {
                mf = this.cachedOneModel(clzStr);
                GLog.debug("\u6dfb\u52a0model[{}]\u81f3\u7f13\u5b58", clzStr);
                this.cached.put(clzStr, mf);
            }
            catch (Exception e) {
                GLog.error("cachedOneModel error, clz:" + clzStr, e);
            }
        }
        return mf;
    }

    public void init(Set<String> clzSets) {
        if (clzSets == null || clzSets.isEmpty()) {
            return;
        }
        try {
            for (String clz : clzSets) {
                ModelFabric mf = this.cachedOneModel(clz);
                GLog.debug("\u6dfb\u52a0model[{}]\u81f3\u7f13\u5b58", clz);
                this.cached.put(clz, mf);
            }
        }
        catch (Exception e) {
            GLog.error("init error", e);
        }
    }

    private ModelFabric cachedOneModel(String clzStr) throws Exception {
        boolean isUseAttribute;
        Class<?> clz = Class.forName(clzStr);
        AttributeColumnMapping mapping = clz.getAnnotation(AttributeColumnMapping.class);
        Table table = clz.getAnnotation(Table.class);
        PrimaryKey pk = clz.getAnnotation(PrimaryKey.class);
        PrimaryKey[] pkList = null;
        if (pk != null) {
            pkList = new PrimaryKey[]{pk};
        }
        Map<String, Field> fieldMap = ModelBuilder.getObjectAllFieldsMap(clz);
        List<Field> fields = ModelBuilder.getObjectAllFields(clz);
        ModelFabric mf = new ModelFabric();
        mf.setClz(clz);
        mf.setFieldMap(fieldMap);
        mf.setFields(fields);
        mf.setMapping(mapping);
        mf.setPkList(pkList);
        mf.setTable(table);
        HashMap<String, String> attrMapping = new HashMap<String, String>();
        boolean bl = isUseAttribute = mapping == null || mapping.useAttribute();
        if (isUseAttribute) {
            Set<String> attrs = fieldMap.keySet();
            for (String attr : attrs) {
                attrMapping.put(attr, attr);
            }
        } else {
            String[] paires;
            for (String paire : paires = mapping.value()) {
                String[] p = StringUtils.split((String)paire, (String)":");
                attrMapping.put(p[0], p[1]);
            }
            if (attrMapping.isEmpty()) {
                attrMapping.putAll(ModelCacheManager.getMappingFromFileJavaToDb(mapping.mappingFile()));
            }
        }
        mf.setAttrMapping(attrMapping);
        return mf;
    }

    private static Map<String, String> getMappingFromFileJavaToDb(String resource) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        if (StrKit.isBlank(resource)) {
            return mapping;
        }
        Properties p = MappingFileManager.get().getMappingFile(resource);
        Set<Object> keys = p.keySet();
        for (Object key : keys) {
            String value = p.getProperty(key.toString());
            mapping.put(key.toString(), value);
        }
        return mapping;
    }

    public void clear() {
        Set<Map.Entry<String, ModelFabric>> entries = this.cached.entrySet();
        for (Map.Entry<String, ModelFabric> item : entries) {
            item.getValue().clear();
        }
        this.cached.clear();
    }
}

