/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.xmapper.xml;

import cn.sylinx.hbatis.ext.xmapper.xml.IgnoreDTDEntityResolver;
import cn.sylinx.hbatis.ext.xmapper.xml.QueryMapping;
import cn.sylinx.hbatis.ext.xmapper.xml.Sql;
import cn.sylinx.hbatis.io.ClasspathResourceScanner;
import cn.sylinx.hbatis.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;

public class XmlSqlMapper {
    private static final Log logger = LogFactory.getLog(XmlSqlMapper.class);
    private AtomicBoolean inited = new AtomicBoolean(false);
    private final SAXReader reader = new SAXReader();
    private final Map<String, Map<String, Sql>> SQL_POOL = new HashMap<String, Map<String, Sql>>();
    private static XmlSqlMapper instance = new XmlSqlMapper();

    public static XmlSqlMapper get() {
        return instance;
    }

    public boolean isInited() {
        return this.inited.get();
    }

    public void clear() {
        this.inited.set(false);
        this.SQL_POOL.clear();
    }

    private XmlSqlMapper() {
        this.reader.setEntityResolver((EntityResolver)new IgnoreDTDEntityResolver());
    }

    public Sql getSqlBySqlId(String nameSpaceId_id) {
        if (StringUtils.isBlank((String)nameSpaceId_id)) {
            return null;
        }
        if (!nameSpaceId_id.contains(".")) {
            return null;
        }
        if (!this.inited.get()) {
            return null;
        }
        String[] ids = nameSpaceId_id.split("\\.");
        return this.getSqlBySqlId(ids[0], ids[1]);
    }

    public Sql getSqlBySqlId(String nameSpaceId, String id) {
        if (!this.inited.get()) {
            return null;
        }
        Map<String, Sql> sqs = this.SQL_POOL.get(nameSpaceId);
        if (sqs == null || sqs.isEmpty()) {
            logger.error((Object)("\u547d\u540d\u7a7a\u95f4\uff1a" + nameSpaceId + " \u6ca1\u6709\u67e5\u8be2\u8bed\u53e5"));
            return null;
        }
        return sqs.get(id);
    }

    private void loadOne(String r) throws Exception {
        InputStream is = null;
        try {
            is = Resources.getResourceAsStream(r);
            if (is != null) {
                Document doc = this.reader.read(is);
                XmlSqlMapper.get().parseXml(doc);
            }
        }
        catch (Exception e) {
            logger.error((Object)"load one xml error", (Throwable)e);
            throw e;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean load(String resourcesPath) {
        ClasspathResourceScanner crs = new ClasspathResourceScanner(resourcesPath);
        List<String> rlist = null;
        try {
            rlist = crs.getResourceNameList();
        }
        catch (Exception e) {
            logger.error((Object)"resource not found ", (Throwable)e);
            return false;
        }
        if (rlist == null || rlist.isEmpty()) {
            return false;
        }
        try {
            for (String r : rlist) {
                this.loadOne(r);
            }
        }
        catch (Exception e) {
            this.clear();
            return false;
        }
        this.inited.set(true);
        return true;
    }

    private void parseXml(Document doc) throws DocumentException {
        Element nameSpace = doc.getRootElement();
        String nameSpaceId = nameSpace.element("nameSpaceId").getTextTrim();
        Map<String, Sql> qss = this.SQL_POOL.get(nameSpaceId);
        if (qss == null) {
            qss = new HashMap<String, Sql>();
            this.SQL_POOL.put(nameSpaceId, qss);
        }
        Element sqlList = nameSpace.element("sqlList");
        List sqls = sqlList.elements("sql");
        Sql oneSql = null;
        QueryMapping mapping = null;
        for (Element sql : sqls) {
            oneSql = new Sql();
            oneSql.setNameSpaceId(nameSpaceId);
            String id = sql.attributeValue("id");
            oneSql.setId(id);
            String forUse = sql.attributeValue("forUse");
            oneSql.setForUse(forUse);
            Element statement = sql.element("statement");
            oneSql.setStatement(statement.getTextTrim());
            Element queryMapping = sql.element("queryMapping");
            if (queryMapping != null) {
                List entrys;
                mapping = new QueryMapping();
                Element returnClass = queryMapping.element("returnClass");
                mapping.setReturnClass(returnClass.getTextTrim());
                Element map = queryMapping.element("map");
                if (map != null && (entrys = map.elements("entry")) != null && !entrys.isEmpty()) {
                    HashMap<String, String> kvs = new HashMap<String, String>();
                    for (Element entry : entrys) {
                        String key = entry.attributeValue("key");
                        String value = entry.attributeValue("value");
                        kvs.put(key, value);
                    }
                    mapping.setMap(kvs);
                }
                oneSql.setQueryMapping(mapping);
            }
            qss.put(id, oneSql);
        }
    }
}

