/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.hbatis.ext.spi;

import cn.sylinx.hbatis.db.common.HbatisService;
import cn.sylinx.hbatis.ext.mirage.MirageService;
import cn.sylinx.hbatis.ext.xmapper.XmapperService;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantLock;

public class HbatisServiceManager {
    private static HbatisService hbatisService;
    private static MirageService mirageService;
    private static XmapperService xmapperService;
    private static ReentrantLock lock1;
    private static ReentrantLock lock2;
    private static ReentrantLock lock3;

    public static <T extends HbatisService> T use(Class<T> c) {
        boolean isMirageService = MirageService.class.isAssignableFrom(c);
        if (isMirageService) {
            return (T)HbatisServiceManager.getMirageService();
        }
        boolean isXmapperService = XmapperService.class.isAssignableFrom(c);
        if (isXmapperService) {
            return (T)HbatisServiceManager.getXmapperService();
        }
        boolean isHbatisService = HbatisService.class.isAssignableFrom(c);
        if (isHbatisService) {
            return (T)HbatisServiceManager.getHbatisService();
        }
        return null;
    }

    public static HbatisService getHbatisService() {
        if (hbatisService != null) {
            return hbatisService;
        }
        HbatisServiceManager.loadHbatisService();
        return hbatisService;
    }

    private static void loadHbatisService() {
        try {
            lock1.lock();
            if (hbatisService == null) {
                ServiceLoader<HbatisService> sl = ServiceLoader.load(HbatisService.class);
                Iterator<HbatisService> it = sl.iterator();
                hbatisService = it.hasNext() ? it.next() : null;
            }
        }
        finally {
            lock1.unlock();
        }
    }

    public static MirageService getMirageService() {
        if (mirageService != null) {
            return mirageService;
        }
        HbatisServiceManager.loadMirageService();
        return mirageService;
    }

    private static void loadMirageService() {
        try {
            lock2.lock();
            if (mirageService == null) {
                ServiceLoader<MirageService> sl = ServiceLoader.load(MirageService.class);
                Iterator<MirageService> it = sl.iterator();
                mirageService = it.hasNext() ? it.next() : null;
            }
        }
        finally {
            lock2.unlock();
        }
    }

    public static XmapperService getXmapperService() {
        if (xmapperService != null) {
            return xmapperService;
        }
        HbatisServiceManager.loadXmapperService();
        return xmapperService;
    }

    private static void loadXmapperService() {
        try {
            lock3.lock();
            if (xmapperService == null) {
                ServiceLoader<XmapperService> sl = ServiceLoader.load(XmapperService.class);
                Iterator<XmapperService> it = sl.iterator();
                xmapperService = it.hasNext() ? it.next() : null;
            }
        }
        finally {
            lock3.unlock();
        }
    }

    static {
        lock1 = new ReentrantLock();
        lock2 = new ReentrantLock();
        lock3 = new ReentrantLock();
    }
}

